/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record LimbMaterialStats(int durability, float drawSpeed, float velocity, float accuracy) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("limb"));
    public static final MaterialStatType<LimbMaterialStats> TYPE = new MaterialStatType<LimbMaterialStats>(ID, new LimbMaterialStats(1, 0.0f, 0.0f, 0.0f), RecordLoadable.create(IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)FloatLoadable.ANY.defaultField("draw_speed", (Object)Float.valueOf(0.0f), true, LimbMaterialStats::drawSpeed), (RecordField)FloatLoadable.ANY.defaultField("velocity", (Object)Float.valueOf(0.0f), true, LimbMaterialStats::velocity), (RecordField)FloatLoadable.ANY.defaultField("accuracy", (Object)Float.valueOf(0.0f), true, LimbMaterialStats::accuracy), LimbMaterialStats::new));
    static final String ACCURACY_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("accuracy"));
    static final String DRAW_SPEED_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("draw_speed"));
    static final String VELOCITY_PREFIX = IMaterialStats.makeTooltipKey(TConstruct.getResource("velocity"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.DRAW_SPEED.getDescription(), (Object)ToolStats.VELOCITY.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());

    @Override
    public MaterialStatType<?> getType() {
        return TYPE;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(IToolStat.formatColoredBonus(DRAW_SPEED_PREFIX, this.drawSpeed));
        info.add(IToolStat.formatColoredBonus(VELOCITY_PREFIX, this.velocity));
        info.add(IToolStat.formatColoredBonus(ACCURACY_PREFIX, this.accuracy));
        return info;
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        ToolStats.DRAW_SPEED.add(builder, this.drawSpeed * scale);
        ToolStats.VELOCITY.add(builder, this.velocity * scale);
        ToolStats.ACCURACY.add(builder, this.accuracy * scale);
    }
}

