/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record HeadMaterialStats(int durability, float miningSpeed, Tier tier, float attack) implements IRepairableMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("head"));
    public static final MaterialStatType<HeadMaterialStats> TYPE = new MaterialStatType<HeadMaterialStats>(ID, new HeadMaterialStats(1, 1.0f, (Tier)Tiers.WOOD, 1.0f), RecordLoadable.create(IRepairableMaterialStats.DURABILITY_FIELD, (RecordField)FloatLoadable.FROM_ZERO.defaultField("mining_speed", (Object)Float.valueOf(1.0f), true, HeadMaterialStats::miningSpeed), (RecordField)TinkerLoadables.TIER.defaultField("mining_tier", (Object)Tiers.WOOD, true, HeadMaterialStats::tier), (RecordField)FloatLoadable.FROM_ZERO.defaultField("melee_attack", (Object)Float.valueOf(1.0f), true, HeadMaterialStats::attack), HeadMaterialStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.HARVEST_TIER.getDescription(), (Object)ToolStats.MINING_SPEED.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());

    @Override
    public MaterialStatType<?> getType() {
        return TYPE;
    }

    @Override
    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(ToolStats.HARVEST_TIER.formatValue(this.tier));
        info.add(ToolStats.MINING_SPEED.formatValue(this.miningSpeed));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.attack));
        return info;
    }

    @Override
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.update(builder, Float.valueOf((float)this.durability * scale));
        ToolStats.ATTACK_DAMAGE.update(builder, Float.valueOf(this.attack * scale));
        ToolStats.MINING_SPEED.update(builder, Float.valueOf(this.miningSpeed * scale));
        ToolStats.HARVEST_TIER.update(builder, this.tier);
    }
}

