/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.OverslimeModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public enum OverburnModule implements ModifierModule,
InventoryTickModifierHook,
ModifierRemovalHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    private final SingletonLoader<OverburnModule> loader = new SingletonLoader((Object)this);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove(modifier.getId());
        return null;
    }

    @Override
    public void onInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        int level = Math.min(modifier.getLevel(), 6);
        int updateInterval = 5 << 6 - level;
        if (!world.f_46443_ && holder.f_19797_ % updateInterval == 0 && holder.m_21211_() != stack && OverslimeModule.INSTANCE.getAmount(tool) < OverslimeModule.getCapacity(tool)) {
            ModifierId key = modifier.getId();
            FuelInfo info = FuelInfo.read(tool, key);
            boolean neededFuel = info == null;
            long time = holder.m_9236_().m_46467_();
            if (neededFuel || info.expiration < time) {
                MeltingFuel fuel;
                info = null;
                FluidStack fluid = ToolTankHelper.TANK_HELPER.getFluid(tool);
                if (!fluid.isEmpty() && (fuel = MeltingFuelLookup.findFuel(fluid.getFluid())) != null) {
                    int amount = fuel.getAmount(fluid.getFluid());
                    int duration = fuel.getDuration() * updateInterval / 5;
                    if (amount > fluid.getAmount()) {
                        ToolTankHelper.TANK_HELPER.setFluid(tool, FluidStack.EMPTY);
                        duration = duration * fluid.getAmount() / amount;
                    } else {
                        fluid.shrink(amount);
                        ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
                    }
                    info = new FuelInfo(time + (long)duration, fuel.getRate());
                }
                if (info != null && info.expiration >= time + (long)updateInterval) {
                    info.write(tool, key);
                } else if (!neededFuel) {
                    tool.getPersistentData().remove(key);
                }
            }
            if (info != null) {
                int restore = info.rate / 10;
                int remainder = info.rate % 10;
                if (remainder > 0 && Modifier.RANDOM.nextInt(10) < remainder) {
                    ++restore;
                }
                OverslimeModule.INSTANCE.addAmount(tool, restore);
            }
        }
    }

    public SingletonLoader<OverburnModule> getLoader() {
        return this.loader;
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.INVENTORY_TICK, ModifierHooks.REMOVE);
    }

    private record FuelInfo(long expiration, int rate) {
        private static final String EXPIRATION = "expiration";
        private static final String RATE = "rate";

        @Nullable
        public static FuelInfo read(IToolStackView tool, ResourceLocation location) {
            ModDataNBT persistentData = tool.getPersistentData();
            if (persistentData.contains(location, 10)) {
                CompoundTag tag = persistentData.getCompound(location);
                return new FuelInfo(tag.m_128454_(EXPIRATION), tag.m_128451_(RATE));
            }
            return null;
        }

        public void write(IToolStackView tool, ResourceLocation location) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_(EXPIRATION, this.expiration);
            tag.m_128405_(RATE, this.rate);
            tool.getPersistentData().put(location, (Tag)tag);
        }
    }
}

