/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data;

import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.PotionDisplayIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.json.predicate.material.MaterialHasPartPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.json.predicate.material.MaterialStatTypePredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.CompositeCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.PartSwapCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.material.ToolCastingRecipe;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialValueIngredient;
import slimeknights.tconstruct.library.recipe.material.MaterialsConsumerBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.PartRecipeBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.partbuilder.recycle.PartBuilderRecycleBuilder;
import slimeknights.tconstruct.library.recipe.partbuilder.recycle.PartBuilderToolRecycleBuilder;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipeBuilder;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;

public class ToolsRecipeProvider
extends BaseRecipeProvider
implements IMaterialRecipeHelper,
IToolRecipeHelper {
    public ToolsRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Tool Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addToolBuildingRecipes(consumer);
        this.addPartRecipes(consumer);
        this.addRecycleRecipes(consumer);
    }

    private void addToolBuildingRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/building/";
        String armorFolder = "tools/armor/";
        this.toolBuilding(consumer, (Supplier)TinkerTools.pickaxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.sledgeHammer, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.veinHammer, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.mattock, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.pickadze, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.excavator, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.handAxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.broadAxe, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.kama, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.scythe, folder);
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.dagger.get()).outputSize(2).save(consumer, this.prefix((IdAwareObject)TinkerTools.dagger, folder));
        this.toolBuilding(consumer, (Supplier)TinkerTools.sword, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.cleaver, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.crossbow, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.longbow, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.fishingRod, folder);
        this.toolBuilding(consumer, (Supplier)TinkerTools.javelin, folder);
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.arrow.get()).outputSize(4).save(consumer, this.prefix((IdAwareObject)TinkerTools.arrow, folder));
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.shuriken.get()).layoutSlot(Patterns.THROWN_AMMO).outputSize(4).save(consumer, this.prefix((IdAwareObject)TinkerTools.shuriken, folder));
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.throwingAxe.get()).layoutSlot(Patterns.THROWN_AMMO).outputSize(2).save(consumer, this.prefix((IdAwareObject)TinkerTools.throwingAxe, folder));
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.arrow.get()).addExtraRequirement(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42412_})).noParts().addExtraMaterial(MaterialIds.flint, MaterialIds.wood, MaterialIds.feather).layoutSlot(TinkerTables.tinkerStation.getId()).save(consumer, this.wrap((IdAwareObject)TinkerTools.arrow, folder, "_from_vanilla"));
        ToolBuildingRecipeBuilder.toolBuildingRecipe((IModifiable)TinkerTools.arrow.get()).addExtraRequirement((Ingredient)PotionDisplayIngredient.of((ItemLike[])new ItemLike[]{Items.f_42738_})).noParts().addExtraMaterial(MaterialIds.flint, MaterialIds.wood, MaterialIds.feather).tippedModifier(ModifierIds.tipped).layoutSlot(TinkerTables.tinkerStation.getId()).save(consumer, this.wrap((IdAwareObject)TinkerTools.arrow, folder, "_from_tipped"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.TOOLS, TinkerTools.flintAndBrick).m_126209_((ItemLike)Items.f_42484_).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.searedBrick, TinkerSmeltery.scorchedBrick})).m_126132_("has_seared", (CriterionTriggerInstance)ToolsRecipeProvider.m_125977_(TinkerSmeltery.searedBrick)).m_126132_("has_scorched", (CriterionTriggerInstance)ToolsRecipeProvider.m_125977_(TinkerSmeltery.scorchedBrick)).m_126140_(consumer, this.prefix((IdAwareObject)TinkerTools.flintAndBrick, folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, TinkerTools.skyStaff).m_126130_("CWC").m_126130_(" I ").m_126130_(" W ").m_126127_(Character.valueOf('C'), (ItemLike)TinkerWorld.skyGeode).m_206416_(Character.valueOf('W'), TinkerWorld.skyroot.getLogItemTag()).m_206416_(Character.valueOf('I'), TinkerMaterials.roseGold.getIngotTag()).m_126132_("has_wood", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)TinkerWorld.skyroot.getLogItemTag())).m_126140_(consumer, this.prefix((IdAwareObject)TinkerTools.skyStaff, folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, TinkerTools.earthStaff).m_126130_("CWC").m_126130_(" I ").m_126130_(" W ").m_126127_(Character.valueOf('C'), (ItemLike)TinkerWorld.earthGeode).m_206416_(Character.valueOf('W'), TinkerWorld.greenheart.getLogItemTag()).m_206416_(Character.valueOf('I'), TinkerMaterials.cobalt.getIngotTag()).m_126132_("has_wood", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)TinkerWorld.greenheart.getLogItemTag())).m_126140_(consumer, this.prefix((IdAwareObject)TinkerTools.earthStaff, folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, TinkerTools.ichorStaff).m_126130_("CWC").m_126130_(" I ").m_126130_(" W ").m_126127_(Character.valueOf('C'), (ItemLike)TinkerWorld.ichorGeode).m_206416_(Character.valueOf('W'), TinkerWorld.bloodshroom.getLogItemTag()).m_206416_(Character.valueOf('I'), TinkerMaterials.queensSlime.getIngotTag()).m_126132_("has_wood", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)TinkerWorld.bloodshroom.getLogItemTag())).m_126140_(consumer, this.prefix((IdAwareObject)TinkerTools.ichorStaff, folder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, TinkerTools.enderStaff).m_126130_("CWC").m_126130_(" I ").m_126130_(" W ").m_126127_(Character.valueOf('C'), (ItemLike)TinkerWorld.enderGeode).m_206416_(Character.valueOf('W'), TinkerWorld.enderbark.getLogItemTag()).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_NETHERITE).m_126132_("has_wood", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)TinkerWorld.enderbark.getLogItemTag())).m_126140_(consumer, this.prefix((IdAwareObject)TinkerTools.enderStaff, folder));
        String travelersFolder = armorFolder + "travelers/";
        Consumer<FinishedRecipe> shapedMaterial = MaterialsConsumerBuilder.shaped("c").material(MaterialIds.leather).build(consumer);
        Function<MaterialStatsId, Ingredient> travelersMaterial = type -> CompoundIngredient.of((Ingredient[])new Ingredient[]{MaterialValueIngredient.of(MaterialPredicate.and(MaterialPredicate.or(MaterialPredicate.CASTABLE, MaterialPredicate.COMPOSITE), new MaterialStatTypePredicate((MaterialStatsId)((Object)type))), 1.0f), MaterialIngredient.of(TinkerToolParts.fakeIngot, (IJsonPredicate<MaterialVariantId>)new MaterialStatTypePredicate((MaterialStatsId)((Object)type)))});
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.HELMET))).m_126130_("l l").m_126130_("glg").m_126130_("c c").m_126124_(Character.valueOf('c'), travelersMaterial.apply(PlatingMaterialStats.HELMET.getId())).m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_206416_(Character.valueOf('g'), Tags.Items.GLASS_PANES_COLORLESS).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_126140_(shapedMaterial, this.location(travelersFolder + "goggles"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.CHESTPLATE))).m_126130_("l l").m_126130_("lcl").m_126130_("lcl").m_126124_(Character.valueOf('c'), travelersMaterial.apply(PlatingMaterialStats.CHESTPLATE.getId())).m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_126140_(shapedMaterial, this.location(travelersFolder + "chestplate"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.LEGGINGS))).m_126130_("lll").m_126130_("c c").m_126130_("l l").m_126124_(Character.valueOf('c'), travelersMaterial.apply(PlatingMaterialStats.LEGGINGS.getId())).m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_126140_(shapedMaterial, this.location(travelersFolder + "pants"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.BOOTS))).m_126130_("c c").m_126130_("l l").m_126124_(Character.valueOf('c'), travelersMaterial.apply(PlatingMaterialStats.BOOTS.getId())).m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_126140_(shapedMaterial, this.location(travelersFolder + "boots"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, TinkerTools.travelersShield).m_126130_("cl").m_126130_("lc").m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_126124_(Character.valueOf('c'), (Ingredient)MaterialValueIngredient.of(new MaterialStatTypePredicate(StatlessMaterialStats.SHIELD_CORE.getIdentifier()), 1.0f)).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_126140_(shapedMaterial, this.location(travelersFolder + "shield"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.HELMET)}), 3).index(1).save(consumer, this.location(travelersFolder + "goggles_leather"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.CHESTPLATE)}), 6).index(1).save(consumer, this.location(travelersFolder + "chestplate_leather"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.LEGGINGS)}), 5).index(1).save(consumer, this.location(travelersFolder + "pants_leather"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.BOOTS)}), 2).index(1).save(consumer, this.location(travelersFolder + "boots_leather"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerTools.travelersShield}), 2).index(1).save(consumer, this.location(travelersFolder + "shield_leather"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])((ItemLike[])TinkerTools.travelersGear.values().toArray(new Item[0]))), 2).save(consumer, this.location(travelersFolder + "swapping_metal"));
        String plateFolder = armorFolder + "plate/";
        TinkerTools.plateArmor.forEach(item -> this.toolBuilding(consumer, (IModifiable)item, plateFolder, Patterns.PLATE_ARMOR));
        MaterialCastingRecipeBuilder.tableRecipe((IModifiable)TinkerTools.plateShield.get()).setCast((Ingredient)MaterialIngredient.of(TinkerToolParts.shieldCore), ToolCastingRecipe.CastPurpose.FIRST_MATERIAL).setItemCost(3).save(consumer, this.location(plateFolder + "plate_shield"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.plateArmor.get((Enum)ArmorItem.Type.HELMET)}), 3).save(consumer, this.location(plateFolder + "helmet_swapping"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.plateArmor.get((Enum)ArmorItem.Type.CHESTPLATE)}), 6).save(consumer, this.location(plateFolder + "chestplate_swapping"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.plateArmor.get((Enum)ArmorItem.Type.LEGGINGS)}), 5).save(consumer, this.location(plateFolder + "leggings_swapping"));
        PartSwapCastingRecipeBuilder.tableRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TinkerTools.plateArmor.get((Enum)ArmorItem.Type.BOOTS)}), 2).save(consumer, this.location(plateFolder + "boots_swapping"));
        this.slimeskullCasting(consumer, MaterialIds.glass, (ItemLike)Items.f_42682_, armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.bone, (ItemLike)Items.f_42678_, armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.necroticBone, (ItemLike)Items.f_42679_, armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.leather, (ItemLike)Items.f_42681_, armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.gold, (ItemLike)Items.f_260451_, armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.enderPearl, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.ENDERMAN), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.venombone, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.STRAY), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.string, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.SPIDER), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.darkthread, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.CAVE_SPIDER), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.iron, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.HUSK), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.copper, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.DROWNED), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.blazingBone, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.BLAZE), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.roseGold, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.PIGLIN_BRUTE), armorFolder);
        this.slimeskullCasting(consumer, MaterialIds.pigIron, (ItemLike)TinkerWorld.heads.get((Enum)TinkerHeadType.ZOMBIFIED_PIGLIN), armorFolder);
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.CHESTPLATE)).setCast((ItemLike)Items.f_42741_, true).setFluidAndTime((FluidObject<?>)TinkerFluids.enderSlime, 8000).save(consumer, this.location(armorFolder + "slimelytra"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.LEGGINGS)).setCast((ItemLike)Items.f_42748_, true).setFluidAndTime((FluidObject<?>)TinkerFluids.enderSlime, 7000).save(consumer, this.location(armorFolder + "slimeshell"));
        ItemCastingRecipeBuilder.basinRecipe((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.BOOTS)).setCast((ItemLike)Items.f_42648_, true).setFluidAndTime((FluidObject<?>)TinkerFluids.enderSlime, 4000).save(consumer, this.location(armorFolder + "slime_boots"));
    }

    private void addRecycleRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "tools/recycling/";
        PartBuilderToolRecycleBuilder.tools(SizedIngredient.of((Ingredient)DifferenceIngredient.of((Ingredient)Ingredient.m_204132_(TinkerTags.Items.MULTIPART_TOOL), (Ingredient)Ingredient.m_204132_(TinkerTags.Items.UNRECYCLABLE)))).save(consumer, this.location(folder + "general"));
        PartBuilderToolRecycleBuilder.tools(SizedIngredient.fromItems((int)2, (ItemLike[])new ItemLike[]{TinkerTools.dagger})).save(consumer, this.location(folder + "dagger"));
        PartBuilderToolRecycleBuilder.tools(SizedIngredient.fromItems((ItemLike[])((ItemLike[])TinkerTools.travelersGear.values().toArray(Item[]::new)))).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).part((Supplier<? extends IMaterialItem>)TinkerToolParts.maille).save(consumer, this.location(folder + "travelers_gear"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.travelersShield).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).part((Supplier<? extends IMaterialItem>)TinkerToolParts.maille).save(consumer, this.location(folder + "travelers_shield"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.plateShield).part((Supplier<? extends IMaterialItem>)TinkerToolParts.shieldCore).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).save(consumer, this.location(folder + "plate_shield"));
        PartBuilderRecycleBuilder.tool(new ItemLike[]{TinkerTools.flintAndBrick}).result(new Pattern("tconstruct", "shard"), (ItemLike)Items.f_42484_, 1).save(consumer, this.location(folder + "flint_and_brick"));
        Pattern log = new Pattern("tconstruct", "block");
        Pattern ingot = new Pattern("tconstruct", "ingot");
        Pattern crystal = new Pattern("tconstruct", "crystal");
        PartBuilderRecycleBuilder.tool(new ItemLike[]{TinkerTools.earthStaff}).result(crystal, (ItemLike)TinkerWorld.earthGeode, 2).result(log, (ItemLike)TinkerWorld.skyroot.getLog(), 2).result(ingot, (TagKey<Item>)TinkerMaterials.roseGold.getIngotTag(), 1).save(consumer, this.location(folder + "earth_staff"));
        PartBuilderRecycleBuilder.tool(new ItemLike[]{TinkerTools.skyStaff}).result(crystal, (ItemLike)TinkerWorld.skyGeode, 2).result(log, (ItemLike)TinkerWorld.greenheart.getLog(), 2).result(ingot, (TagKey<Item>)TinkerMaterials.cobalt.getIngotTag(), 1).save(consumer, this.location(folder + "sky_staff"));
        PartBuilderRecycleBuilder.tool(new ItemLike[]{TinkerTools.ichorStaff}).result(crystal, (ItemLike)TinkerWorld.ichorGeode, 2).result(log, (ItemLike)TinkerWorld.bloodshroom.getLog(), 2).result(ingot, (TagKey<Item>)TinkerMaterials.queensSlime.getIngotTag(), 1).save(consumer, this.location(folder + "ichor_staff"));
        PartBuilderRecycleBuilder.tool(new ItemLike[]{TinkerTools.enderStaff}).result(crystal, (ItemLike)TinkerWorld.enderGeode, 2).result(log, (ItemLike)TinkerWorld.enderbark.getLog(), 2).result(ingot, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, 1).save(consumer, this.location(folder + "ender_staff"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.meltingPan).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).part((Supplier<? extends IMaterialItem>)TinkerToolParts.bowLimb).save(consumer, this.location(folder + "melting_pan"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.warPick).part((Supplier<? extends IMaterialItem>)TinkerToolParts.pickHead).part((Supplier<? extends IMaterialItem>)TinkerToolParts.bowLimb).part((Supplier<? extends IMaterialItem>)TinkerToolParts.bowstring).save(consumer, this.location(folder + "war_pick"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.battlesign).part((Supplier<? extends IMaterialItem>)TinkerToolParts.largePlate).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).save(consumer, this.location(folder + "battlesign"));
        PartBuilderToolRecycleBuilder.tool(TinkerTools.swasher).part((Supplier<? extends IMaterialItem>)TinkerToolParts.smallBlade).part((Supplier<? extends IMaterialItem>)TinkerToolParts.toolHandle).part((Supplier<? extends IMaterialItem>)TinkerToolParts.bowGrip).save(consumer, this.location(folder + "swasher"));
        PartBuilderToolRecycleBuilder.tools(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{TinkerTools.minotaurAxe.getId()}))).part((Supplier<? extends IMaterialItem>)TinkerToolParts.smallAxeHead).part((Supplier<? extends IMaterialItem>)TinkerToolParts.repairKit).part((Supplier<? extends IMaterialItem>)TinkerToolParts.toolHandle).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("twilightforest")}), this.location(folder + "minotaur_axe"));
    }

    private void addPartRecipes(Consumer<FinishedRecipe> consumer) {
        String partFolder = "tools/parts/";
        String castFolder = "smeltery/casts/";
        this.partRecipes(consumer, (Supplier)TinkerToolParts.repairKit, TinkerSmeltery.repairKitCast, 2, partFolder, castFolder);
        this.partCasting(consumer, (IMaterialItem)TinkerToolParts.fakeIngot.get(), TinkerSmeltery.ingotCast, 1, partFolder);
        MaterialCastingRecipeBuilder.basinRecipe(TinkerToolParts.fakeStorageBlockItem.get()).setItemCost(9).save(consumer, this.location(partFolder + "fake_storage_block_casting"));
        CompositeCastingRecipeBuilder.basin(TinkerToolParts.fakeStorageBlockItem.get(), 9).save(consumer, this.location(partFolder + "fake_storage_block_composite"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, TinkerToolParts.fakeStorageBlock).m_126124_(Character.valueOf('#'), (Ingredient)MaterialIngredient.of(TinkerToolParts.fakeIngot.get(), (IJsonPredicate<MaterialVariantId>)new MaterialHasPartPredicate(TinkerToolParts.fakeStorageBlockItem.get()))).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_125977_(TinkerToolParts.fakeIngot)).m_126140_(MaterialsConsumerBuilder.shaped("#").build(consumer), this.location(partFolder + "fake_ingot_to_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, TinkerToolParts.fakeIngot, (int)9).m_126184_((Ingredient)MaterialIngredient.of(TinkerToolParts.fakeStorageBlock, (IJsonPredicate<MaterialVariantId>)new MaterialHasPartPredicate((IMaterialItem)TinkerToolParts.fakeIngot.get()))).m_126132_("has_item", (CriterionTriggerInstance)ToolsRecipeProvider.m_125977_(TinkerToolParts.fakeStorageBlock)).m_126140_(MaterialsConsumerBuilder.shapeless(1).build(consumer), this.location(partFolder + "fake_block_to_ingots"));
        this.partRecipes(consumer, (Supplier)TinkerToolParts.pickHead, TinkerSmeltery.pickHeadCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.hammerHead, TinkerSmeltery.hammerHeadCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.smallAxeHead, TinkerSmeltery.smallAxeHeadCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.broadAxeHead, TinkerSmeltery.broadAxeHeadCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.smallBlade, TinkerSmeltery.smallBladeCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.broadBlade, TinkerSmeltery.broadBladeCast, 8, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.bowLimb, TinkerSmeltery.bowLimbCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.bowGrip, TinkerSmeltery.bowGripCast, 2, partFolder, castFolder);
        ItemCastingRecipeBuilder.tableRecipe(TinkerSmeltery.arrowCast).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenGold, 90).setCast((TagKey<Item>)ItemTags.f_13161_, true).save(consumer, this.location(castFolder + "gold/arrow"));
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toolBinding, TinkerSmeltery.toolBindingCast, 1, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toughBinding, TinkerSmeltery.toughBindingCast, 3, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.adzeHead, TinkerSmeltery.adzeHeadCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.largePlate, TinkerSmeltery.largePlateCast, 4, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toolHandle, TinkerSmeltery.toolHandleCast, 1, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.toughHandle, TinkerSmeltery.toughHandleCast, 3, partFolder, castFolder);
        this.partWithDummy(consumer, (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.HELMET), (ItemLike)TinkerSmeltery.dummyPlating.get((Enum)ArmorItem.Type.HELMET), TinkerSmeltery.helmetPlatingCast, 3, partFolder, castFolder);
        this.partWithDummy(consumer, (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.CHESTPLATE), (ItemLike)TinkerSmeltery.dummyPlating.get((Enum)ArmorItem.Type.CHESTPLATE), TinkerSmeltery.chestplatePlatingCast, 6, partFolder, castFolder);
        this.partWithDummy(consumer, (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.LEGGINGS), (ItemLike)TinkerSmeltery.dummyPlating.get((Enum)ArmorItem.Type.LEGGINGS), TinkerSmeltery.leggingsPlatingCast, 5, partFolder, castFolder);
        this.partWithDummy(consumer, (IMaterialItem)TinkerToolParts.plating.get((Enum)ArmorItem.Type.BOOTS), (ItemLike)TinkerSmeltery.dummyPlating.get((Enum)ArmorItem.Type.BOOTS), TinkerSmeltery.bootsPlatingCast, 2, partFolder, castFolder);
        this.partRecipes(consumer, (Supplier)TinkerToolParts.maille, TinkerSmeltery.mailleCast, 2, partFolder, castFolder);
        this.uncastablePart(consumer, (IMaterialItem)TinkerToolParts.bowstring.get(), 1, null, partFolder);
        this.uncastablePart(consumer, (IMaterialItem)TinkerToolParts.shieldCore.get(), 4, PlatingMaterialStats.SHIELD.getId(), partFolder);
        Ingredient arrowPattern = CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(TinkerTags.Items.DEFAULT_PATTERNS), Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerSmeltery.arrowCast})});
        PartRecipeBuilder.partRecipe((IMaterialItem)TinkerToolParts.arrowHead.get()).setPattern(TinkerToolParts.arrowHead.getId()).setPatternItem(arrowPattern).setCost(1).setAllowUncraftable(true).save(consumer, this.location(partFolder + "builder/arrow_head"));
        PartRecipeBuilder.partRecipe((IMaterialItem)TinkerToolParts.arrowShaft.get()).setPattern(TinkerToolParts.arrowShaft.getId()).setPatternItem(arrowPattern).setCost(1).setAllowUncraftable(true).save(consumer, this.location(partFolder + "builder/arrow_shaft"));
        PartRecipeBuilder.partRecipe((IMaterialItem)TinkerToolParts.fletching.get()).setPattern(TinkerToolParts.fletching.getId()).setPatternItem(arrowPattern).setCost(1).setAllowUncraftable(true).save(consumer, this.location(partFolder + "builder/fletching"));
    }

    private void slimeskullCasting(Consumer<FinishedRecipe> consumer, MaterialId material, ItemLike skull, String folder) {
        MaterialIdNBT nbt = new MaterialIdNBT(Collections.singletonList(material));
        ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromStack((ItemStack)nbt.updateStack(new ItemStack((ItemLike)TinkerTools.slimesuit.get((Enum)ArmorItem.Type.HELMET))))).setCast(skull, true).setFluidAndTime((FluidObject<?>)TinkerFluids.enderSlime, 5000).save(consumer, this.location(folder + "slime_skull/" + material.m_135815_()));
    }
}

