/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.data.GenericNBTProvider;

public abstract class AbstractStructureRepalleter
extends GenericNBTProvider {
    private final Multimap<ResourceLocation, RepaletteTask> structures = HashMultimap.create();
    private final ExistingFileHelper existingFileHelper;
    private final String modId;

    public AbstractStructureRepalleter(PackOutput packOutput, ExistingFileHelper existingFileHelper, String modId) {
        super(packOutput, PackOutput.Target.DATA_PACK, "structures");
        this.existingFileHelper = existingFileHelper;
        this.modId = modId;
    }

    public abstract void addStructures();

    private ListTag repaletteNBT(ListTag palette, Map<String, String> repalette) {
        for (int i = 0; i < palette.size(); ++i) {
            CompoundTag block = palette.m_128728_(i);
            String newName = repalette.get(block.m_128461_("Name"));
            if (newName == null) continue;
            block.m_128359_("Name", newName);
        }
        return palette;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addStructures();
        ArrayList tasks = new ArrayList();
        for (Map.Entry entry : this.structures.asMap().entrySet()) {
            ResourceLocation original = (ResourceLocation)entry.getKey();
            try {
                InputStream io = this.existingFileHelper.getResource(original, PackType.SERVER_DATA, ".nbt", "structures").m_215507_();
                try {
                    CompoundTag inputNBT = NbtIo.m_128939_((InputStream)io);
                    for (RepaletteTask task : (Collection)entry.getValue()) {
                        CompoundTag newStructure = inputNBT.m_6426_();
                        ListTag palette = newStructure.m_128437_("palette", 10);
                        if (task.replacements.length == 1) {
                            this.repaletteNBT(palette, task.replacements[0].build());
                        } else {
                            newStructure.m_128473_("palette");
                            ListTag palettes = new ListTag();
                            for (Replacement replacement : task.replacements) {
                                palettes.add((Object)this.repaletteNBT(palette.m_6426_(), replacement.build()));
                            }
                            newStructure.m_128365_("palettes", (Tag)palettes);
                        }
                        if (task.reprocess) {
                            StructureTemplate template = new StructureTemplate();
                            template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), newStructure);
                            newStructure = template.m_74618_(new CompoundTag());
                        }
                        tasks.add(this.saveNBT(cache, new ResourceLocation(this.modId, task.location), newStructure));
                    }
                }
                finally {
                    if (io == null) continue;
                    io.close();
                }
            }
            catch (IOException e) {
                TConstruct.LOG.error("Couldn't read NBT for {}", (Object)original, (Object)e);
            }
        }
        return GenericDataProvider.allOf(tasks);
    }

    protected Replacement replacement() {
        return new Replacement();
    }

    protected void repalette(ResourceLocation original, String target, boolean reprocess, Replacement ... replacements) {
        if (replacements.length == 0) {
            throw new IllegalArgumentException("Must have at least 1 replacement");
        }
        this.structures.put((Object)original, (Object)new RepaletteTask(target, reprocess, replacements));
    }

    private record RepaletteTask(String location, boolean reprocess, Replacement[] replacements) {
    }

    public static class Replacement {
        private final ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        private Map<String, String> built;

        public Replacement addMapping(ResourceLocation from, ResourceLocation to) {
            this.built = null;
            this.builder.put((Object)from.toString(), (Object)to.toString());
            return this;
        }

        public Replacement addMapping(Block from, Block to) {
            return this.addMapping(BuiltInRegistries.f_256975_.m_7981_((Object)from), BuiltInRegistries.f_256975_.m_7981_((Object)to));
        }

        private Map<String, String> build() {
            if (this.built == null) {
                this.built = this.builder.build();
            }
            return this.built;
        }

        public Replacement copy() {
            Replacement replacement = new Replacement();
            replacement.builder.putAll(this.build());
            return replacement;
        }

        private Replacement() {
        }
    }
}

