/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.content.AbstractMaterialContent;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

public class ContentMaterialSkull
extends AbstractMaterialContent {
    private static final Component SKULL = TConstruct.makeTranslation("book", "material.skull");
    private static final String SKULL_FROM = TConstruct.makeTranslationKey("book", "material.skull_from");
    public static final ResourceLocation ID = TConstruct.getResource("skull_material");
    protected transient IDisplayableCastingRecipe skullRecipe = null;
    private transient boolean searchedSkullRecipe = false;
    protected transient List<ItemStack> skullStacks = null;

    public ContentMaterialSkull(MaterialVariantId material, boolean detailed) {
        super(material, detailed);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    @Nullable
    protected MaterialStatsId getStatType(int index) {
        return index == 0 ? SkullStats.ID : null;
    }

    @Override
    protected String getTextKey(MaterialId material) {
        return String.format(this.detailed ? "material.%s.%s.skull_encyclopedia" : "material.%s.%s.skull_flavor", material.m_135827_(), material.m_135815_());
    }

    @Nullable
    private IDisplayableCastingRecipe getSkullRecipe() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (!this.searchedSkullRecipe && world != null) {
            this.skullRecipe = world.m_7465_().m_44013_((RecipeType)TinkerRecipeTypes.CASTING_BASIN.get()).stream().filter(recipe -> recipe instanceof IDisplayableCastingRecipe).map(recipe -> (IDisplayableCastingRecipe)((Object)recipe)).filter(recipe -> {
                ItemStack output = recipe.getOutput();
                return output.m_41720_() == TinkerTools.slimesuit.get((Enum)ArmorItem.Type.HELMET) && MaterialIdNBT.from(output).getMaterial(0).getId().toString().equals(this.materialName);
            }).findFirst().orElse(null);
            this.searchedSkullRecipe = true;
        }
        return this.skullRecipe;
    }

    @Override
    public Component getTitleComponent() {
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null) {
            return skullRecipe.getOutput().m_41786_();
        }
        return super.getTitleComponent();
    }

    @Override
    public List<ItemStack> getDisplayStacks() {
        List<ItemStack> skulls;
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(skulls = skullRecipe.getCastItems()).isEmpty()) {
            return skulls;
        }
        return super.getDisplayStacks();
    }

    @Override
    protected boolean supportsStatType(MaterialStatsId statsId) {
        return statsId.equals((Object)SkullStats.ID);
    }

    @Override
    protected void addPrimaryDisplayItems(List<ItemElement> displayTools, MaterialVariantId materialId) {
        List<ItemStack> casts;
        displayTools.add(new TinkerItemElement(((RepairKitItem)TinkerToolParts.repairKit.get()).withMaterialForDisplay(materialId)));
        super.addPrimaryDisplayItems(displayTools, materialId);
        IDisplayableCastingRecipe skullRecipe = this.getSkullRecipe();
        if (skullRecipe != null && !(casts = skullRecipe.getCastItems()).isEmpty()) {
            TinkerItemElement elementItem = new TinkerItemElement(0, 0, 1.0f, casts);
            elementItem.tooltip = List.of(SKULL, Component.m_237110_((String)SKULL_FROM, (Object[])new Object[]{casts.get(0).m_41786_()}).m_130940_(ChatFormatting.GRAY));
            displayTools.add(elementItem);
        }
    }
}

