/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.library.client.armor.AbstractArmorModel;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public class MultilayerArmorModel
extends AbstractArmorModel {
    public static final MultilayerArmorModel INSTANCE = new MultilayerArmorModel();
    protected ItemStack armorStack = ItemStack.f_41583_;
    protected ArmorModelManager.ArmorModel model = ArmorModelManager.ArmorModel.EMPTY;
    protected RegistryAccess registryAccess = RegistryAccess.f_243945_;

    protected MultilayerArmorModel() {
    }

    public Model setup(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> base, ArmorModelManager.ArmorModel model) {
        this.model = model;
        this.registryAccess = living.m_9236_().m_9598_();
        if (!model.layers().isEmpty()) {
            this.setup(living, stack, slot, base);
            this.armorStack = stack;
        } else {
            this.armorStack = ItemStack.f_41583_;
        }
        return this;
    }

    public void m_7695_(PoseStack matrices, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.base != null && buffer != null) {
            boolean armorGlint = this.hasGlint;
            boolean wingGlint = this.hasGlint;
            for (ArmorTextureSupplier textureSupplier : this.model.layers()) {
                ArmorTextureSupplier.ArmorTexture texture = textureSupplier.getArmorTexture(this.armorStack, this.textureType, this.registryAccess);
                if (texture != ArmorTextureSupplier.ArmorTexture.EMPTY) {
                    texture.renderTexture((Model)this.base, matrices, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha, armorGlint);
                    armorGlint = false;
                }
                if (!this.hasWings || (texture = textureSupplier.getArmorTexture(this.armorStack, ArmorTextureSupplier.TextureType.WINGS, this.registryAccess)) == ArmorTextureSupplier.ArmorTexture.EMPTY) continue;
                this.renderWings(matrices, packedLightIn, packedOverlayIn, texture, red, green, blue, alpha, wingGlint);
                wingGlint = false;
            }
        }
    }
}

