/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TippingCastingRecipe
extends PotionCastingRecipe {
    protected static final LoadableField<Ingredient, PotionCastingRecipe> TOOL_FIELD = IngredientLoadable.DISALLOW_EMPTY.requiredField("tools", r -> r.bottle);
    public static final RecordLoadable<TippingCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, TOOL_FIELD, (RecordField)FLUID_FIELD, (RecordField)COOLING_TIME_FIELD, (RecordField)ModifierId.PARSER.requiredField("modifier", r -> r.modifier), TippingCastingRecipe::new);
    private final ModifierId modifier;

    public TippingCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient tool, FluidIngredient fluid, int coolingTime, ModifierId modifier) {
        super(serializer, id, group, tool, fluid, Items.f_41852_, coolingTime);
        this.modifier = modifier;
    }

    @Override
    public boolean matches(ICastingContainer inv, Level level) {
        ItemStack stack = inv.getStack();
        if (super.matches(inv, level) && ModifierUtil.getModifierLevel(stack, this.modifier) > 0) {
            CompoundTag fluidTag = inv.getFluidTag();
            return fluidTag != null && fluidTag.m_128425_("Potion", 8) && !ModifierUtil.getPersistentString(stack, this.modifier).equals(fluidTag.m_128461_("Potion"));
        }
        return false;
    }

    @Override
    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack result = inv.getStack().m_41777_();
        CompoundTag tag = inv.getFluidTag();
        if (tag != null) {
            ToolStack.from(result).getPersistentData().putString(this.modifier, tag.m_128461_("Potion"));
        }
        return result;
    }

    @Override
    public List<DisplayCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> tools = Arrays.stream(this.bottle.m_43908_()).map(stack -> IDisplayModifierRecipe.withModifiers(IModifiableDisplay.getDisplayStack(stack), List.of(new ModifierEntry(this.modifier, 1)))).toList();
            this.displayRecipes = ForgeRegistries.POTIONS.getValues().stream().filter(potion -> potion != Potions.f_43598_).map(potion -> {
                String id = Loadables.POTION.getString(potion);
                List<ItemStack> results = tools.stream().map(stack -> {
                    ToolStack tool = ToolStack.copyFrom(stack);
                    tool.getPersistentData().putString(this.modifier, id);
                    return tool.copyStack((ItemStack)stack);
                }).toList();
                CompoundTag fluidNBT = new CompoundTag();
                fluidNBT.m_128359_("Potion", id);
                return new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), tools, this.fluid.getFluids().stream().map(fluid -> new FluidStack(fluid.getFluid(), fluid.getAmount(), fluidNBT)).toList(), results, this.coolingTime, true);
            }).toList();
        }
        return this.displayRecipes;
    }
}

