/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import java.util.List;
import net.minecraft.tags.TagKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModule
extends CapacityBarHook.PersistentDataCapacityBar {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.CAPACITY_BAR);
    public static final OverslimeModule INSTANCE = new OverslimeModule();
    public static final FloatToolStat OVERSLIME_STAT = new FloatToolStat(new ToolStatId("tconstruct", "overslime"), -9315195, 0.0f, 0.0f, 32767.0f, (TagKey)TinkerTags.Items.DURABILITY){

        @Override
        public Float build(ModifierStatsBuilder parent, Object builderObj) {
            return Float.valueOf(super.build(parent, builderObj).floatValue() * parent.getMultiplier(ToolStats.DURABILITY));
        }
    };

    private OverslimeModule() {
        super(TinkerModifiers.overslime.getId());
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public void setAmountRaw(ModDataNBT persistentData, int amount) {
        if (amount <= 0) {
            persistentData.remove(this.key);
        } else {
            persistentData.putInt(this.key, amount);
        }
    }

    public static int getCapacity(IToolStackView tool) {
        return tool.getStats().getInt(OVERSLIME_STAT);
    }

    @Override
    public int getCapacity(IToolStackView tool, ModifierEntry entry) {
        return OverslimeModule.getCapacity(tool);
    }

    public static int getOverworkedBonus(IToolStackView tool) {
        return 1 + tool.getModifierLevel(TinkerModifiers.overworked.getId());
    }

    @Override
    public void addAmount(IToolStackView tool, ModifierEntry entry, int amount) {
        super.addAmount(tool, entry, amount * OverslimeModule.getOverworkedBonus(tool));
    }

    public void addAmount(IToolStackView tool, int amount) {
        this.addAmount(tool, ModifierEntry.EMPTY, amount);
    }

    public void removeAmount(IToolStackView tool, int amount) {
        this.removeAmount(tool, ModifierEntry.EMPTY, amount);
    }
}

