/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.client.materials.MaterialTextureField;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

public record MaterialRenderInfo(MaterialVariantId id, @Nullable ResourceLocation texture, String[] fallbacks, int vertexColor, int luminosity) {
    public static final RecordLoadable<MaterialRenderInfo> LOADABLE = RecordLoadable.create((RecordField)MaterialVariantId.CONTEXT_KEY.requiredField(), (RecordField)MaterialTextureField.INSTANCE, (RecordField)StringLoadable.DEFAULT.array(String[]::new, false, 0).emptyField("fallbacks", MaterialRenderInfo::fallbacks), (RecordField)ColorLoadable.ALPHA.defaultField("color", false, MaterialRenderInfo::vertexColor), (RecordField)IntLoadable.range((int)0, (int)15).defaultField("luminosity", (Object)0, MaterialRenderInfo::luminosity), MaterialRenderInfo::new);

    @Nullable
    private TextureAtlasSprite trySprite(Material base, String suffix, Function<Material, TextureAtlasSprite> spriteGetter) {
        Material materialTexture = MaterialRenderInfo.getMaterial(base.m_119203_(), suffix);
        TextureAtlasSprite sprite = spriteGetter.apply(materialTexture);
        if (!MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_245424_().m_246162_())) {
            return sprite;
        }
        return null;
    }

    public TintedSprite getSprite(Material base, Function<Material, TextureAtlasSprite> spriteGetter) {
        TextureAtlasSprite sprite;
        if (this.texture != null && (sprite = this.trySprite(base, MaterialRenderInfo.getSuffix(this.texture), spriteGetter)) != null) {
            return new TintedSprite(sprite, -1, this.luminosity);
        }
        for (String fallback : this.fallbacks) {
            sprite = this.trySprite(base, fallback, spriteGetter);
            if (sprite == null) continue;
            return new TintedSprite(sprite, this.vertexColor, this.luminosity);
        }
        return new TintedSprite(spriteGetter.apply(base), this.vertexColor, this.luminosity);
    }

    public static String getSuffix(ResourceLocation material) {
        if ("minecraft".equals(material.m_135827_())) {
            return material.m_135815_();
        }
        return material.m_135827_() + "_" + material.m_135815_();
    }

    private static Material getMaterial(ResourceLocation texture, String suffix) {
        return new Material(InventoryMenu.f_39692_, new ResourceLocation(texture.m_135827_(), texture.m_135815_() + "_" + suffix));
    }

    public record TintedSprite(TextureAtlasSprite sprite, int color, int emissivity) {
    }
}

