/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import slimeknights.tconstruct.world.TinkerStructures;

public class LeaveVineDecorator
extends TreeDecorator {
    public static final Codec<LeaveVineDecorator> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("vines").forGetter(d -> d.vines), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(d -> Float.valueOf(d.probability))).apply((Applicative)inst, LeaveVineDecorator::new));
    private final Block vines;
    private final float probability;

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)TinkerStructures.leaveVineDecorator.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        context.m_226069_().forEach(pos -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offset;
                if (!(random.m_188501_() < this.probability) || !context.m_226059_(offset = pos.m_121945_(direction))) continue;
                this.addHangingVine(offset, VineBlock.m_57883_((Direction)direction.m_122424_()), context);
            }
        });
    }

    private void placeVine(BlockPos pos, BooleanProperty property, TreeDecorator.Context context) {
        context.m_226061_(pos, (BlockState)this.vines.m_49966_().m_61124_((Property)property, (Comparable)Boolean.TRUE));
    }

    private void addHangingVine(BlockPos pos, BooleanProperty property, TreeDecorator.Context context) {
        this.placeVine(pos, property, context);
        BlockPos target = pos.m_7495_();
        for (int i = 4; context.m_226059_(target) && i > 0; --i) {
            this.placeVine(target, property, context);
            target = target.m_7495_();
        }
    }

    public LeaveVineDecorator(Block vines, float probability) {
        this.vines = vines;
        this.probability = probability;
    }
}

