/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.DummyToolStack;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.modifiers.effect.BleedingEffect;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public class LaceratingModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
OnAttackedModifierHook {
    private static void applyEffect(IToolStackView tool, @Nullable LivingEntity holder, LivingEntity target, int level, @Nullable EquipmentSlot slot) {
        int looting = 0;
        DamageSource source = CombatHelper.damageSource(TinkerDamageTypes.BLEEDING, (Entity)target);
        if (holder != null) {
            LootingContext context = new LootingContext(holder, target, source, slot);
            looting = LootingModifierHook.getLooting(tool, context, looting);
            looting = ArmorLootingModifierHook.getLooting(null, context, looting);
        }
        LaceratingModifier.applyEffect(target, level, looting);
    }

    private static void applyEffect(LivingEntity target, int level, int looting) {
        int duration = level * 2 * 20;
        MobEffectInstance existing = target.m_21124_((MobEffect)TinkerEffects.bleeding.get());
        duration = existing != null && existing.m_19564_() == looting ? (duration += existing.m_19557_()) : (duration += 19);
        ((BleedingEffect)((Object)TinkerEffects.bleeding.get())).apply(target, duration, looting, true);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.ON_ATTACKED);
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && context.isFullyCharged() && target.m_6084_()) {
            target.m_21335_((Entity)context.getAttacker());
            LaceratingModifier.applyEffect(tool, context.getAttacker(), target, modifier.getLevel(), context.getSlotType());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_()) && target.m_6084_()) {
            Entity owner = projectile.m_19749_();
            if (owner != null) {
                target.m_21335_(owner);
            }
            if (attacker != null) {
                LaceratingModifier.applyEffect(new DummyToolStack(Items.f_41852_, modifiers, persistentData), attacker, target, modifier.getLevel(), null);
            } else {
                LaceratingModifier.applyEffect(target, modifier.getLevel(), 0);
            }
        }
        return false;
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity entity;
        if (isDirectDamage && tool.hasTag(TinkerTags.Items.ARMOR) && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            float chance = 0.25f;
            if (CounterModule.isBlocking(tool, slotType, context.getEntity())) {
                chance *= 2.0f;
            }
            if (RANDOM.nextFloat() < chance) {
                LaceratingModifier.applyEffect(tool, context.getEntity(), attacker, modifier.getLevel(), slotType);
            }
        }
    }
}

