/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.function.Consumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import slimeknights.mantle.command.argument.TagSource;
import slimeknights.mantle.command.argument.TagSourceArgument;
import slimeknights.mantle.registration.deferred.ArgumentTypeDeferredRegister;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.shared.command.argument.MaterialArgument;
import slimeknights.tconstruct.shared.command.argument.MaterialStatsArgument;
import slimeknights.tconstruct.shared.command.argument.MaterialVariantArgument;
import slimeknights.tconstruct.shared.command.argument.ModifierArgument;
import slimeknights.tconstruct.shared.command.argument.ModifierHookArgument;
import slimeknights.tconstruct.shared.command.argument.ModifierTagSource;
import slimeknights.tconstruct.shared.command.argument.SlotTypeArgument;
import slimeknights.tconstruct.shared.command.argument.ToolStatArgument;
import slimeknights.tconstruct.shared.command.subcommand.GenerateMeltingRecipesCommand;
import slimeknights.tconstruct.shared.command.subcommand.GeneratePartTexturesCommand;
import slimeknights.tconstruct.shared.command.subcommand.MaterialsCommand;
import slimeknights.tconstruct.shared.command.subcommand.ModifierPriorityCommand;
import slimeknights.tconstruct.shared.command.subcommand.ModifierUsageCommand;
import slimeknights.tconstruct.shared.command.subcommand.ModifiersCommand;
import slimeknights.tconstruct.shared.command.subcommand.SlotsCommand;
import slimeknights.tconstruct.shared.command.subcommand.StatsCommand;

public class TConstructCommand {
    public static final DynamicCommandExceptionType COMPONENT_ERROR = new DynamicCommandExceptionType(error -> (Component)error);
    private static final ArgumentTypeDeferredRegister ARGUMENT_TYPE = new ArgumentTypeDeferredRegister("tconstruct");

    public static void init() {
        ARGUMENT_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        ARGUMENT_TYPE.registerSingleton("slot_type", SlotTypeArgument.class, SlotTypeArgument::slotType);
        ARGUMENT_TYPE.registerSingleton("tool_stat", ToolStatArgument.class, ToolStatArgument::stat);
        ARGUMENT_TYPE.registerSingleton("modifier", ModifierArgument.class, ModifierArgument::modifier);
        ARGUMENT_TYPE.registerSingleton("material", MaterialArgument.class, MaterialArgument::material);
        ARGUMENT_TYPE.registerSingleton("material_variant", MaterialVariantArgument.class, MaterialVariantArgument::material);
        ARGUMENT_TYPE.registerSingleton("material_stat", MaterialStatsArgument.class, MaterialStatsArgument::stats);
        ARGUMENT_TYPE.registerSingleton("modifier_hook", ModifierHookArgument.class, ModifierHookArgument::modifierHook);
        TagSourceArgument.registerCustom((TagSource)ModifierTagSource.INSTANCE);
        TagSourceArgument.registerCustom(MaterialRegistry.getTagSource());
        MinecraftForge.EVENT_BUS.addListener(TConstructCommand::registerCommand);
    }

    private static void register(LiteralArgumentBuilder<CommandSourceStack> root, String name, Consumer<LiteralArgumentBuilder<CommandSourceStack>> consumer) {
        LiteralArgumentBuilder subCommand = Commands.m_82127_((String)name);
        consumer.accept((LiteralArgumentBuilder<CommandSourceStack>)subCommand);
        root.then((ArgumentBuilder)subCommand);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"tconstruct");
        CommandBuildContext context = event.getBuildContext();
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "modifiers", ModifiersCommand::register);
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "materials", MaterialsCommand::register);
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "tool_stats", StatsCommand::register);
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "slots", SlotsCommand::register);
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "report", b -> {
            TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "modifier_usage", ModifierUsageCommand::register);
            TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "modifier_priority", ModifierPriorityCommand::register);
        });
        TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)builder, "generate", b -> {
            TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "part_textures", GeneratePartTexturesCommand::register);
            TConstructCommand.register((LiteralArgumentBuilder<CommandSourceStack>)b, "melting_recipes", bb -> GenerateMeltingRecipesCommand.register((LiteralArgumentBuilder<CommandSourceStack>)bb, context));
        });
        event.getDispatcher().register(builder);
    }
}

