/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data;

import com.google.common.hash.Hashing;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;

public abstract class GenericNBTProvider
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final String folder;

    public GenericNBTProvider(PackOutput output, PackOutput.Target type, String folder) {
        this(output.m_245269_(type, folder), folder);
    }

    public GenericNBTProvider(DataGenerator generator, PackOutput.Target type, String folder) {
        this(generator.getPackOutput(), type, folder);
    }

    public ResourceLocation localize(ResourceLocation name) {
        return JsonHelper.localize((ResourceLocation)name, (String)this.folder, (String)".nbt");
    }

    protected CompletableFuture<?> saveNBT(CachedOutput cache, ResourceLocation location, CompoundTag data) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                NbtIo.m_128947_((CompoundTag)data, (OutputStream)outputStream);
                byte[] bytes = outputStream.toByteArray();
                Path outputPath = this.pathProvider.m_245527_(location, "nbt");
                cache.m_213871_(outputPath, bytes, Hashing.sha1().hashBytes(bytes));
            }
            catch (IOException e) {
                TConstruct.LOG.error("Couldn't write NBT for {}", (Object)location, (Object)e);
                throw new CompletionException(e);
            }
        }, Util.m_183991_());
    }

    public GenericNBTProvider(PackOutput.PathProvider pathProvider, String folder) {
        this.pathProvider = pathProvider;
        this.folder = folder;
    }
}

