/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.fluids.block;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import slimeknights.mantle.registration.deferred.FluidDeferredRegister;

public class BurningLiquidBlock
extends LiquidBlock {
    private final int burnTime;
    private final float damage;

    public BurningLiquidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties, int burnTime, float damage) {
        super(supplier, properties);
        this.burnTime = burnTime;
        this.damage = damage;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.m_5825_() && entity.getFluidTypeHeight(this.getFluid().getFluidType()) > 0.0) {
            entity.m_20254_(this.burnTime);
            if (entity.m_6469_(entity.m_269291_().m_269233_(), this.damage)) {
                entity.m_5496_(SoundEvents.f_11909_, 0.4f, 2.0f + level.f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public static Function<Supplier<? extends FlowingFluid>, LiquidBlock> createBurning(MapColor color, int lightLevel, int burnTime, float damage) {
        return fluid -> new BurningLiquidBlock((Supplier<? extends FlowingFluid>)fluid, FluidDeferredRegister.createProperties((MapColor)color, (int)lightLevel), burnTime, damage);
    }
}

