/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.durability;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public record ShareDurabilityModule(LazyModifier shield, LevelingInt grant, LevelingInt consume) implements ModifierModule,
ToolDamageModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.TOOL_DAMAGE);
    public static final RecordLoadable<ShareDurabilityModule> LOADER = RecordLoadable.create((RecordField)ModifierId.PARSER.requiredField("shield", m -> m.shield.getId()), (RecordField)LevelingInt.LOADABLE.requiredField("grant", ShareDurabilityModule::grant), (RecordField)LevelingInt.LOADABLE.requiredField("consume", ShareDurabilityModule::consume), ShareDurabilityModule::new);

    public ShareDurabilityModule(ModifierId modifier, LevelingInt grant, LevelingInt consumed) {
        this(new LazyModifier(modifier), grant, consumed);
    }

    public RecordLoadable<ShareDurabilityModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        return ToolDamageModifierHook.super.onDamageTool(tool, modifier, amount, holder, null);
    }

    private static boolean canTarget(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(TinkerTags.Items.DURABILITY);
    }

    private static void consider(List<ItemStack> list, ItemStack check, @Nullable ItemStack skip) {
        if (check != skip && ShareDurabilityModule.canTarget(check)) {
            list.add(check);
        }
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder, @Nullable ItemStack stack) {
        if (holder != null) {
            ArrayList<ItemStack> options = new ArrayList<ItemStack>(10);
            if (tool.hasTag(TinkerTags.Items.WORN_ARMOR)) {
                for (EquipmentSlot slot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                    ItemStack check = holder.m_6844_(slot);
                    if (!ShareDurabilityModule.canTarget(check) || check.m_41720_() == tool.getItem()) continue;
                    options.add(check);
                }
            } else {
                if (holder instanceof Player) {
                    Player player = (Player)holder;
                    Inventory inventory = player.m_150109_();
                    for (int i = 0; i < 9; ++i) {
                        ShareDurabilityModule.consider(options, inventory.m_8020_(i), stack);
                    }
                } else {
                    ShareDurabilityModule.consider(options, holder.m_21205_(), stack);
                }
                ShareDurabilityModule.consider(options, holder.m_21206_(), stack);
            }
            if (!options.isEmpty()) {
                int consumed = Math.min(this.consume.compute(modifier.getEffectiveLevel()) * amount, tool.getCurrentDurability());
                int granted = this.grant.compute(modifier.getEffectiveLevel());
                if (consumed > 0 && granted > 0) {
                    ToolDamageUtil.directDamage(tool, consumed, holder, stack);
                    ItemStack choiceStack = (ItemStack)options.get(TConstruct.RANDOM.nextInt(options.size()));
                    ToolStack choice = ToolStack.from(choiceStack);
                    Modifier shield = this.shield.get();
                    ModifierEntry entry = choice.getModifier(shield);
                    if (entry.getLevel() == 0) {
                        entry = new ModifierEntry(shield, 1);
                        choice.addModifier(shield.getId(), 1);
                    }
                    shield.getHook(ModifierHooks.CAPACITY_BAR).addAmount(choice, entry, granted * amount);
                }
            }
        }
        return amount;
    }
}

