/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialValueIngredient;
import slimeknights.tconstruct.library.recipe.material.ShapedMaterialsRecipe;
import slimeknights.tconstruct.tables.TinkerTables;

@Deprecated
public class ShapedMaterialRecipe
extends ShapedRecipe {
    private MaterialValueIngredient material;
    private final List<MaterialVariantId> extraMaterials;

    public ShapedMaterialRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, boolean showNotification, List<MaterialVariantId> extraMaterials) {
        super(id, group, category, width, height, ingredients, result, showNotification);
        this.extraMaterials = extraMaterials;
    }

    public ShapedMaterialRecipe(ShapedRecipe recipe, List<MaterialVariantId> extraMaterials) {
        this(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245232_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.f_44149_, recipe.m_271738_(), extraMaterials);
    }

    @Deprecated(forRemoval=true)
    public ShapedMaterialRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, boolean showNotification) {
        this(id, group, category, width, height, ingredients, result, showNotification, List.of());
    }

    @Deprecated(forRemoval=true)
    public ShapedMaterialRecipe(ShapedRecipe recipe) {
        this(recipe, List.of());
    }

    @Nullable
    public MaterialValueIngredient getMaterial() {
        if (this.material == null) {
            for (Ingredient ingredient : this.m_7527_()) {
                if (!(ingredient instanceof MaterialValueIngredient)) continue;
                MaterialValueIngredient materialValue = (MaterialValueIngredient)ingredient;
                if (this.material == null) {
                    this.material = materialValue;
                    continue;
                }
                this.material = this.material.merge(materialValue);
            }
            if (this.material == null) {
                TConstruct.LOG.error("No material ingredient found for material shaped recipe {}, this indicates a broken recipe", (Object)this.m_6423_());
            }
        }
        return this.material;
    }

    @Nullable
    private MaterialVariantId findMaterial(CraftingContainer inventory) {
        MaterialValueIngredient material = this.getMaterial();
        if (material == null) {
            return null;
        }
        MaterialVariantId firstMaterial = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            MaterialVariantId matchedMaterial;
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || (matchedMaterial = material.getMaterial(stack)) == null) continue;
            if (firstMaterial == null) {
                firstMaterial = matchedMaterial;
                continue;
            }
            if (firstMaterial.matchesVariant(matchedMaterial)) continue;
            if (firstMaterial.getId().equals(matchedMaterial.getId())) {
                firstMaterial = firstMaterial.getId();
                continue;
            }
            return null;
        }
        return firstMaterial;
    }

    public boolean m_5818_(CraftingContainer inventory, Level level) {
        if (!super.m_5818_(inventory, level)) {
            return false;
        }
        return this.findMaterial(inventory) != null;
    }

    public void setMaterial(ItemStack stack, MaterialVariantId material) {
        ShapedMaterialsRecipe.setMaterial(stack, material, this.extraMaterials);
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack stack = super.m_5874_(inventory, registryAccess);
        MaterialVariantId material = this.findMaterial(inventory);
        if (material != null) {
            this.setMaterial(stack, material);
        }
        return stack;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.shapedMaterialRecipeSerializer.get();
    }

    public static class Serializer
    implements LoggingRecipeSerializer<ShapedMaterialRecipe> {
        static final Loadable<List<MaterialVariantId>> EXTRA_MATERIALS = ShapedMaterialsRecipe.Serializer.EXTRA_MATERIALS;
        static final LoadableField<List<MaterialVariantId>, ShapedMaterialRecipe> MATERIAL_FIELD = EXTRA_MATERIALS.defaultField("extra_materials", List.of(), r -> r.extraMaterials);

        public ShapedMaterialRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedMaterialRecipe recipe = new ShapedMaterialRecipe((ShapedRecipe)f_44076_.m_6729_(recipeId, json), (List)MATERIAL_FIELD.get(json));
            if (recipe.getMaterial() == null) {
                throw new JsonSyntaxException("Invalid material ingredients for shaped material recipe " + recipeId);
            }
            return recipe;
        }

        @Nullable
        public ShapedMaterialRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)f_44076_.m_8005_(recipeId, buffer);
            List extraMaterials = (List)MATERIAL_FIELD.decode(buffer);
            return recipe == null ? null : new ShapedMaterialRecipe(recipe, extraMaterials);
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ShapedMaterialRecipe recipe) {
            f_44076_.m_6178_(buffer, (Recipe)recipe);
            MATERIAL_FIELD.encode(buffer, (Object)recipe);
        }
    }
}

