/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;

public record MeltingModule(LevelingInt temperature, LevelingInt nuggetsPerMetal, LevelingInt shardsPerGem, ModifierCondition<IToolStackView> condition) implements ModifierModule,
MeleeHitModifierHook,
LauncherHitModifierHook,
ProcessLootModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>,
IMeltingContainer,
IMeltingContainer.IOreRate
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.LAUNCHER_HIT, ModifierHooks.PROCESS_LOOT);
    public static final ResourceLocation FORCE_MELTING = TConstruct.getResource("force_melting");
    public static final RecordLoadable<MeltingModule> LOADER = RecordLoadable.create((RecordField)LevelingInt.LOADABLE.requiredField("temperature", MeltingModule::temperature), (RecordField)LevelingInt.LOADABLE.requiredField("nuggets_per_metal", MeltingModule::nuggetsPerMetal), (RecordField)LevelingInt.LOADABLE.requiredField("shards_per_gem", MeltingModule::shardsPerGem), ModifierCondition.TOOL_FIELD, MeltingModule::new);
    private static IMeltingRecipe lastRecipe = null;
    private static ItemStack stack = ItemStack.f_41583_;
    private static int level = 0;

    public RecordLoadable<MeltingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public ItemStack getStack() {
        return stack;
    }

    @Override
    public int applyOreBoost(IMeltingContainer.OreRateType rate, int amount) {
        return switch (rate) {
            case IMeltingContainer.OreRateType.METAL -> amount * this.nuggetsPerMetal.compute(level) / 9;
            case IMeltingContainer.OreRateType.GEM -> amount * this.shardsPerGem.compute(level) / 9;
            default -> amount;
        };
    }

    @Override
    public IMeltingContainer.IOreRate getOreRate() {
        return this;
    }

    private FluidStack meltItem(ModifierEntry modifier, ItemStack stack, Level world) {
        level = modifier.intEffectiveLevel();
        MeltingModule.stack = stack;
        IMeltingRecipe recipe = lastRecipe;
        if (recipe == null || !recipe.m_5818_((Container)this, world)) {
            recipe = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MELTING.get(), (Container)this, world).orElse(null);
            if (recipe == null) {
                MeltingModule.stack = ItemStack.f_41583_;
                return FluidStack.EMPTY;
            }
            lastRecipe = recipe;
        }
        FluidStack result = FluidStack.EMPTY;
        if (recipe.getTemperature(this) <= this.temperature.compute(level)) {
            result = recipe.getOutput(this);
        }
        MeltingModule.stack = ItemStack.f_41583_;
        return result;
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        if (!this.condition.matches(tool, modifier)) {
            return;
        }
        FluidStack current = ToolTankHelper.TANK_HELPER.getFluid(tool);
        int capacity = ToolTankHelper.TANK_HELPER.getCapacity(tool);
        if (current.getAmount() >= capacity) {
            return;
        }
        boolean forceMelt = tool.getVolatileData().getBoolean(FORCE_MELTING);
        if (forceMelt && context.m_78936_(LootContextParams.f_81461_)) {
            BlockState state = (BlockState)context.m_165124_(LootContextParams.f_81461_);
            forceMelt = tool.getHook(ToolHooks.IS_EFFECTIVE).isToolEffective(tool, state);
        }
        ServerLevel world = context.m_78952_();
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        boolean isDirty = false;
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            FluidStack output = this.meltItem(modifier, stack, (Level)world);
            if (!output.isEmpty() && (current.isEmpty() || current.isFluidEqual(output))) {
                int amount;
                if (forceMelt) {
                    amount = output.getAmount() * stack.m_41613_();
                    iterator.remove();
                } else {
                    int maxCopies = Math.min((capacity - current.getAmount()) / output.getAmount(), stack.m_41613_());
                    if (maxCopies <= 0) continue;
                    amount = output.getAmount() * maxCopies;
                    stack.m_41774_(maxCopies);
                    if (stack.m_41619_()) {
                        iterator.remove();
                    }
                }
                if (current.isEmpty()) {
                    output.setAmount(amount);
                    current = output;
                } else {
                    current.grow(amount);
                }
                isDirty = true;
                continue;
            }
            if (!forceMelt) continue;
            iterator.remove();
        }
        if (isDirty) {
            ToolTankHelper.TANK_HELPER.setFluid(tool, current);
        }
    }

    private void meltTarget(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity target, float damageDealt) {
        if (damageDealt > 0.0f && this.condition.matches(tool, modifier) && target != null) {
            int damagePerOutput;
            FluidStack output;
            EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(target.m_9236_().m_7465_(), target.m_6095_());
            if (recipe != null) {
                output = recipe.getOutput(target);
                damagePerOutput = recipe.getDamage();
            } else {
                output = EntityMeltingModule.getDefaultFluid();
                damagePerOutput = 2;
            }
            FluidStack fluid = ToolTankHelper.TANK_HELPER.getFluid(tool);
            if (fluid.isEmpty() || fluid.isFluidEqual(output)) {
                int fluidAmount = damageDealt < (float)(damagePerOutput * 2) ? (int)((float)output.getAmount() * damageDealt / (float)damagePerOutput) : output.getAmount() * 2;
                if (fluid.isEmpty()) {
                    output.setAmount(fluidAmount);
                    fluid = output;
                } else {
                    fluid.grow(fluidAmount);
                }
                ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            this.meltTarget(tool, modifier, context.getLivingTarget(), damageDealt);
        }
    }

    @Override
    public void onLauncherHitEntity(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        this.meltTarget(tool, modifier, livingTarget, damageDealt);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private LevelingInt temperature = LevelingInt.flat(1000);
        private LevelingInt nuggetsPerMetal = LevelingInt.flat(9);
        private LevelingInt shardsPerGem = LevelingInt.flat(4);

        private Builder() {
        }

        public MeltingModule build() {
            return new MeltingModule(this.temperature, this.nuggetsPerMetal, this.shardsPerGem, this.condition);
        }

        public Builder temperature(LevelingInt temperature) {
            this.temperature = temperature;
            return this;
        }

        public Builder nuggetsPerMetal(LevelingInt nuggetsPerMetal) {
            this.nuggetsPerMetal = nuggetsPerMetal;
            return this;
        }

        public Builder shardsPerGem(LevelingInt shardsPerGem) {
            this.shardsPerGem = shardsPerGem;
            return this;
        }
    }
}

