/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Quaternionf;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.item.ITinkerStationDisplay;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.TinkerTooltipFlags;
import slimeknights.tconstruct.tables.client.inventory.BaseTabbedScreen;
import slimeknights.tconstruct.tables.client.inventory.module.InfoPanelScreen;
import slimeknights.tconstruct.tables.menu.TabbedContainerMenu;

public abstract class ToolTableScreen<T extends BlockEntity, C extends TabbedContainerMenu<T>>
extends BaseTabbedScreen<T, C> {
    private static final Component MODIFIERS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.modifiers");
    private static final Component UPGRADES_TEXT = TConstruct.makeTranslation("gui", "tinker_station.upgrades");
    private static final Component TRAITS_TEXT = TConstruct.makeTranslation("gui", "tinker_station.traits");
    private static final ResourceLocation ICON_TEXTURE = TConstruct.getResource("textures/gui/icons.png");
    protected final InfoPanelScreen<ToolTableScreen<T, C>, C> tinkerInfo;
    protected final InfoPanelScreen<ToolTableScreen<T, C>, C> modifierInfo;
    protected final Player player;
    @Nullable
    protected ArmorStand armorStandPreview;
    protected boolean enableArmorStandPreview = true;
    protected boolean clickedOnArmorStand = false;
    protected int armorStandX = 0;
    protected int armorStandY = 0;
    protected int armorStandScale = 10;
    protected float armorStandAngle = 0.0f;
    protected double armorStandLastMouseX = -1.0;

    public ToolTableScreen(C c, Inventory playerInventory, Component title) {
        super(c, playerInventory, title);
        this.player = playerInventory.f_35978_;
        this.tinkerInfo = new InfoPanelScreen<ToolTableScreen, C>(this, c, playerInventory, title);
        this.tinkerInfo.setTextScale(0.8888889f);
        this.addModule(this.tinkerInfo);
        this.modifierInfo = new InfoPanelScreen<ToolTableScreen, C>(this, c, playerInventory, title);
        this.modifierInfo.setTextScale(0.7777778f);
        this.addModule(this.modifierInfo);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.enableArmorStandPreview) {
            assert (this.f_96541_ != null);
            assert (this.f_96541_.f_91073_ != null);
            this.armorStandPreview = new ArmorStand((Level)this.f_96541_.f_91073_, 0.0, 0.0, 0.0);
            this.armorStandPreview.m_31678_(true);
            this.armorStandPreview.m_31675_(true);
            this.armorStandPreview.f_20883_ = 210.0f;
            this.armorStandPreview.m_146926_(25.0f);
            this.armorStandPreview.f_20885_ = this.armorStandPreview.m_146908_();
            this.armorStandPreview.f_20886_ = this.armorStandPreview.m_146908_();
        }
    }

    protected void renderArmorStand(GuiGraphics graphics) {
        if (this.armorStandPreview != null) {
            Quaternionf pose = new Quaternionf();
            SmithingScreen.f_265867_.rotateY(this.armorStandAngle, pose);
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)this.armorStandX, (int)this.armorStandY, (int)this.armorStandScale, (Quaternionf)pose, null, (LivingEntity)this.armorStandPreview);
            graphics.m_280218_(ICON_TEXTURE, this.armorStandX - 16, this.armorStandY - 16, 0, 184, 32, 32);
        }
    }

    protected void setupArmorStandPreview(int x, int y, int scale) {
        this.armorStandX = this.cornerX + x;
        this.armorStandY = this.cornerY + y;
        this.armorStandScale = scale;
    }

    protected void updateArmorStandPreview(ItemStack stack) {
        if (this.armorStandPreview != null) {
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                this.armorStandPreview.m_8061_(equipmentslot, ItemStack.f_41583_);
            }
            if (!stack.m_41619_()) {
                ItemStack copy = stack.m_41777_();
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    this.armorStandPreview.m_8061_(armor.m_40402_(), copy);
                } else {
                    this.armorStandPreview.m_8061_(EquipmentSlot.OFFHAND, copy);
                }
            }
        }
    }

    protected void updateToolPanel(LazyToolStack lazyToolStack) {
        ToolStack tool = lazyToolStack.getTool();
        Item item = tool.getItem();
        if (item instanceof ITinkerStationDisplay) {
            ITinkerStationDisplay display = (ITinkerStationDisplay)item;
            this.tinkerInfo.setCaption(display.getLocalizedName());
            this.tinkerInfo.setText(display.getStatInformation(tool, (Player)Minecraft.m_91087_().f_91074_, new ArrayList<Component>(), SafeClientAccess.getTooltipKey(), TinkerTooltipFlags.TINKER_STATION));
        } else {
            ItemStack result = lazyToolStack.getStack();
            this.tinkerInfo.setCaption(result.m_41786_());
            ArrayList<Component> list = new ArrayList<Component>();
            result.m_41720_().m_7373_(result, (Level)Minecraft.m_91087_().f_91073_, list, (TooltipFlag)TooltipFlag.Default.f_256752_);
            this.tinkerInfo.setText(list);
        }
    }

    protected void updateModifierPanel(ToolStack tool) {
        Component title;
        RegistryAccess access = this.player.m_9236_().m_9598_();
        ArrayList<Component> modifierNames = new ArrayList<Component>();
        ArrayList<Component> modifierTooltip = new ArrayList<Component>();
        if (ToolTableScreen.m_96637_()) {
            title = TRAITS_TEXT;
            Map<Modifier, Integer> upgrades = tool.getUpgrades().getModifiers().stream().collect(Collectors.toMap(ModifierEntry::getModifier, ModifierEntry::getLevel, Integer::sum));
            for (ModifierEntry entry : tool.getModifierList()) {
                int level;
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true) || (level = entry.getLevel() - upgrades.getOrDefault(mod, 0)) <= 0) continue;
                ModifierEntry trait = new ModifierEntry(entry.getModifier(), level);
                modifierNames.add(mod.getDisplayName(tool, trait, access));
                modifierTooltip.add(mod.getDescription(tool, trait));
            }
        } else {
            List<ModifierEntry> modifiers;
            if (ToolTableScreen.m_96638_()) {
                modifiers = tool.getUpgrades().getModifiers();
                title = UPGRADES_TEXT;
            } else {
                modifiers = tool.getModifierList();
                title = MODIFIERS_TEXT;
            }
            for (ModifierEntry entry : modifiers) {
                Modifier mod = entry.getModifier();
                if (!mod.shouldDisplay(true)) continue;
                modifierNames.add(mod.getDisplayName(tool, entry, access));
                modifierTooltip.add(mod.getDescription(tool, entry));
            }
        }
        this.modifierInfo.setCaption(title);
        this.modifierInfo.setText(modifierNames, modifierTooltip);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        int armorStandBoxW = this.armorStandScale + 30;
        int armorStandBoxH = this.armorStandScale * 2;
        int armorStandBoxX = this.armorStandX - armorStandBoxW / 2;
        int armorStandBoxY = this.armorStandY - armorStandBoxH + 5;
        this.clickedOnArmorStand = this.enableArmorStandPreview && GuiUtil.isHovered((int)mouseX, (int)mouseY, armorStandBoxX, armorStandBoxY, armorStandBoxW, armorStandBoxH);
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        this.clickedOnArmorStand = false;
        this.armorStandLastMouseX = -1.0;
        return super.m_6348_(mouseX, mouseY, state);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double timeSinceLastClick, double unkowwn) {
        if (this.enableArmorStandPreview && this.clickedOnArmorStand && this.armorStandLastMouseX != -1.0) {
            this.armorStandAngle += (float)(mouseX - this.armorStandLastMouseX) / 10.0f;
        }
        this.armorStandLastMouseX = mouseX;
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, timeSinceLastClick, unkowwn);
    }
}

