/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.inventory;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.KeybindInteractModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public enum InventoryMenuModule implements ModifierModule,
KeybindInteractModifierHook,
GeneralInteractionModifierHook,
DisplayNameModifierHook
{
    ANY(TooltipKey.UNKNOWN),
    NORMAL(TooltipKey.NORMAL),
    SHIFT(TooltipKey.SHIFT),
    CONTROL(TooltipKey.CONTROL),
    ALT(TooltipKey.ALT);

    public static final RecordLoadable<InventoryMenuModule> LOADER;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    private final TooltipKey requiredKey;

    public RecordLoadable<InventoryMenuModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public Integer getPriority() {
        return 75;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        return InteractionSource.formatModifierName(tool, entry.getModifier(), name);
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot slot, TooltipKey keyModifier) {
        if (this.requiredKey == TooltipKey.UNKNOWN || this.requiredKey == keyModifier) {
            return ToolInventoryCapability.tryOpenContainer(player.m_6844_(slot), tool, player, slot).m_19077_();
        }
        return false;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (player.m_6047_() && tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            EquipmentSlot slot = source.getSlot(hand);
            return ToolInventoryCapability.tryOpenContainer(player.m_6844_(slot), tool, player, slot);
        }
        return InteractionResult.PASS;
    }

    private InventoryMenuModule(TooltipKey requiredKey) {
        this.requiredKey = requiredKey;
    }

    static {
        LOADER = RecordLoadable.create((RecordField)new EnumLoadable(InventoryMenuModule.class).requiredField("on_key", Function.identity()), Function.identity());
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ARMOR_INTERACT, ModifierHooks.GENERAL_INTERACT, ModifierHooks.DISPLAY_NAME);
    }
}

