/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.math;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.math.PostFixOperator;
import slimeknights.tconstruct.library.json.math.PushConstantOperation;
import slimeknights.tconstruct.library.json.math.PushVariableOperation;
import slimeknights.tconstruct.library.json.math.StackOperation;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;

public record PostFixFormula(List<StackOperation> operations, int numArguments) implements ModifierFormula
{
    @Override
    public float apply(float ... values) {
        if (values.length != this.numArguments) {
            throw new IllegalArgumentException("Expected " + this.numArguments + " arguments, but received " + values.length);
        }
        FloatArrayList stack = new FloatArrayList(5);
        for (StackOperation operation : this.operations) {
            operation.perform((FloatStack)stack, values);
        }
        if (stack.size() != 1) {
            throw new IllegalStateException("Expected 1 value on the stack after evaluation, received " + stack.size());
        }
        return stack.popFloat();
    }

    @Override
    public float processLevel(ModifierEntry modifier) {
        return modifier.getEffectiveLevel();
    }

    public void validateFormula() {
        this.apply(new float[this.numArguments]);
    }

    public static PostFixFormula deserialize(JsonObject json, String[] variableNames) {
        return new PostFixFormula(JsonHelper.parseList((JsonObject)json, (String)"formula", (element, key) -> {
            if (element.isJsonPrimitive()) {
                return StackOperation.deserialize(element.getAsJsonPrimitive(), variableNames);
            }
            throw new JsonSyntaxException("Expected " + key + " to be a string or number, was " + GsonHelper.m_13883_((JsonElement)element));
        }), variableNames.length);
    }

    @Override
    public JsonObject serialize(JsonObject json, String[] variableNames) {
        JsonArray array = new JsonArray();
        for (StackOperation operation : this.operations) {
            array.add((JsonElement)operation.serialize(variableNames));
        }
        json.add("formula", (JsonElement)array);
        return json;
    }

    public static PostFixFormula fromNetwork(FriendlyByteBuf buffer, int numArguments) {
        return PostFixFormula.fromNetwork(buffer, buffer.readShort(), numArguments);
    }

    static PostFixFormula fromNetwork(FriendlyByteBuf buffer, short size, int numArguments) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)StackOperation.fromNetwork(buffer));
        }
        return new PostFixFormula((List<StackOperation>)builder.build(), numArguments);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.writeShort(this.operations.size());
        for (StackOperation operation : this.operations) {
            operation.toNetwork(buffer);
        }
    }

    public static Builder<?> builder(String[] variableNames) {
        return new Builder(variableNames);
    }

    public static class Builder<T extends Builder<T>> {
        private final String[] variableNames;
        private final ImmutableList.Builder<StackOperation> operations = ImmutableList.builder();

        public T operation(StackOperation operation) {
            this.operations.add((Object)operation);
            return (T)this;
        }

        public T constant(float value) {
            return this.operation(new PushConstantOperation(value));
        }

        public T variable(int index) {
            if (index < 0 || index >= this.variableNames.length) {
                throw new IllegalArgumentException("Invalid variable index " + index);
            }
            return this.operation(new PushVariableOperation(index));
        }

        public T add() {
            return this.operation(PostFixOperator.ADD);
        }

        public T subtract() {
            return this.operation(PostFixOperator.SUBTRACT);
        }

        public T subtractFlipped() {
            return this.operation(PostFixOperator.SUBTRACT_FLIPPED);
        }

        public T multiply() {
            return this.operation(PostFixOperator.MULTIPLY);
        }

        public T negate() {
            return this.operation(PostFixOperator.NEGATE);
        }

        public T divide() {
            return this.operation(PostFixOperator.DIVIDE);
        }

        public T divideFlipped() {
            return this.operation(PostFixOperator.DIVIDE_FLIPPED);
        }

        public T power() {
            return this.operation(PostFixOperator.POWER);
        }

        public T sqrt() {
            return this.operation(PostFixOperator.SQRT);
        }

        public T powerFlipped() {
            return this.operation(PostFixOperator.POWER_FLIPPED);
        }

        public T min() {
            return this.operation(PostFixOperator.MIN);
        }

        public T max() {
            return this.operation(PostFixOperator.MAX);
        }

        public T nonNegative() {
            return this.operation(PostFixOperator.NON_NEGATIVE);
        }

        public T percentClamp() {
            return this.operation(PostFixOperator.PERCENT_CLAMP);
        }

        public T abs() {
            return this.operation(PostFixOperator.ABS);
        }

        public T floor() {
            return this.operation(PostFixOperator.FLOOR);
        }

        public T ceil() {
            return this.operation(PostFixOperator.CEIL);
        }

        public T swap() {
            return this.operation(PostFixOperator.SWAP);
        }

        public T duplicate() {
            return this.operation(PostFixOperator.DUPLICATE);
        }

        public T equal() {
            return this.operation(PostFixOperator.EQUAL);
        }

        public T notEqual() {
            return this.operation(PostFixOperator.NOT_EQUAL);
        }

        public T greaterThan() {
            return this.operation(PostFixOperator.GREATER_THAN);
        }

        public T greaterThanOrEqual() {
            return this.operation(PostFixOperator.GREATER_THAN_EQUAL);
        }

        public T lessThan() {
            return this.operation(PostFixOperator.LESS_THAN);
        }

        public T lessThanOrEqual() {
            return this.operation(PostFixOperator.LESS_THAN_EQUAL);
        }

        public T equalEpsilon() {
            return this.operation(PostFixOperator.EQUAL_EPS);
        }

        public T notEqualEpsilon() {
            return this.operation(PostFixOperator.EQUAL_EPS);
        }

        public PostFixFormula buildFormula() {
            PostFixFormula formula = new PostFixFormula((List<StackOperation>)this.operations.build(), this.variableNames.length);
            formula.validateFormula();
            return formula;
        }

        protected Builder(String[] variableNames) {
            this.variableNames = variableNames;
        }
    }
}

