/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.client.inventory.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import slimeknights.mantle.client.screen.MultiModuleScreen;
import slimeknights.tconstruct.tables.client.inventory.widget.SideButtonsWidget;

public class SideButtonsWidgetPaged<T extends Button>
extends SideButtonsWidget<T> {
    private static final int SPACING = 4;
    private static final int MAX_ROWS = 8;
    private final int leftPos;
    private final int topPos;
    private final int buttonHeight;
    private final int buttonWidth;
    private final int columns;
    private int page;
    private Button previousPageButton;
    private Button nextPageButton;
    private int clickedButtonIndex = 0;

    public SideButtonsWidgetPaged(MultiModuleScreen<?> parent, int leftPos, int topPos, int columns, int rows, int buttonWidth, int buttonHeight) {
        super(parent, leftPos, topPos, columns, Math.min(8, rows), buttonWidth, buttonHeight);
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.columns = columns;
        this.buttonHeight = buttonHeight;
        this.buttonWidth = buttonWidth;
        this.previousPageButton = new Button.Builder((Component)Component.m_264568_((String)"button.tconstruct.previous_page", (String)"<"), new Button.OnPress(){

            public void m_93750_(Button button) {
                if (SideButtonsWidgetPaged.this.page > 0) {
                    --SideButtonsWidgetPaged.this.page;
                    SideButtonsWidgetPaged.this.setButtonPositions();
                }
            }
        }).m_252794_(leftPos, topPos).m_253046_(buttonWidth, buttonHeight).m_253136_();
        this.nextPageButton = new Button.Builder((Component)Component.m_264568_((String)"button.tconstruct.next_page", (String)">"), new Button.OnPress(){

            public void m_93750_(Button button) {
                if (!SideButtonsWidgetPaged.this.isMaxPage(SideButtonsWidgetPaged.this.page)) {
                    ++SideButtonsWidgetPaged.this.page;
                    SideButtonsWidgetPaged.this.setButtonPositions();
                }
            }
        }).m_252794_(leftPos + (buttonWidth + 4) * columns, topPos).m_253046_(buttonWidth, buttonHeight).m_253136_();
        this.page = 0;
    }

    private boolean isMaxPage(int page) {
        return this.buttons.size() <= (page + 1) * this.columns * 8;
    }

    @Override
    public boolean handleMouseClicked(double mouseX, double mouseY, int mouseButton) {
        int button_num;
        if (mouseButton == 0 && (button_num = this.buttons.size()) > this.columns * 8) {
            if (this.previousPageButton.m_6375_(mouseX, mouseY, mouseButton)) {
                this.clickedButtonIndex = 1;
                return true;
            }
            if (this.nextPageButton.m_6375_(mouseX, mouseY, mouseButton)) {
                this.clickedButtonIndex = 2;
                return true;
            }
        }
        return super.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int state) {
        if (this.clickedButtonIndex == 1) {
            this.previousPageButton.m_6348_(mouseX, mouseY, state);
            this.clickedButtonIndex = 0;
            return true;
        }
        if (this.clickedButtonIndex == 2) {
            this.nextPageButton.m_6348_(mouseX, mouseY, state);
            this.clickedButtonIndex = 0;
            return true;
        }
        return super.handleMouseReleased(mouseX, mouseY, state);
    }

    @Override
    public void setButtonPositions() {
        Button button;
        int i;
        int button_num = this.buttons.size();
        if (button_num <= this.columns * 8) {
            this.previousPageButton.f_93624_ = false;
            this.nextPageButton.f_93624_ = false;
        }
        int startIndex = this.page * this.columns * 8;
        int endIndex = Math.min(startIndex + this.columns * 8, button_num);
        this.previousPageButton.f_93624_ = this.page > 0;
        this.nextPageButton.f_93624_ = !this.isMaxPage(this.page);
        this.previousPageButton.m_252865_(this.leftPos);
        this.nextPageButton.m_252865_(this.leftPos + (this.buttonWidth + 4) * (this.columns - 1));
        this.previousPageButton.m_253211_(this.topPos - this.buttonHeight);
        this.nextPageButton.m_253211_(this.topPos - this.buttonHeight);
        for (i = 0; i < startIndex; ++i) {
            button = (Button)this.buttons.get(i);
            button.m_252865_(0);
            button.m_253211_(0);
            button.f_93624_ = false;
        }
        for (i = startIndex; i < endIndex; ++i) {
            button = (Button)this.buttons.get(i);
            int x = (i - startIndex) % this.columns * (this.buttonWidth + 4);
            int y = (i - startIndex) / this.columns * (this.buttonHeight + 4);
            button.m_252865_(this.leftPos + x);
            button.m_253211_(this.topPos + y);
            button.f_93624_ = true;
        }
        for (i = endIndex; i < button_num; ++i) {
            button = (Button)this.buttons.get(i);
            button.m_252865_(0);
            button.m_253211_(0);
            button.f_93624_ = false;
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int button_num = this.buttons.size();
        if (button_num > this.columns * 8) {
            this.previousPageButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
            this.nextPageButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        int startIndex = this.page * this.columns * 8;
        int endIndex = Math.min(startIndex + this.columns * 8, button_num);
        for (int i = startIndex; i < endIndex; ++i) {
            Button button = (Button)this.buttons.get(i);
            button.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public int getLeftPos() {
        return this.leftPos;
    }
}

