/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book;

import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.book.transformer.BookTransformer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.TinkerBookIDs;
import slimeknights.tconstruct.library.client.book.content.AmmoMaterialContent;
import slimeknights.tconstruct.library.client.book.content.ArmorMaterialContent;
import slimeknights.tconstruct.library.client.book.content.ContentMaterialSkull;
import slimeknights.tconstruct.library.client.book.content.ContentModifier;
import slimeknights.tconstruct.library.client.book.content.ContentTool;
import slimeknights.tconstruct.library.client.book.content.FluidEffectContent;
import slimeknights.tconstruct.library.client.book.content.MeleeHarvestMaterialContent;
import slimeknights.tconstruct.library.client.book.content.RangedMaterialContent;
import slimeknights.tconstruct.library.client.book.content.TooltipShowcaseContent;
import slimeknights.tconstruct.library.client.book.sectiontransformer.FluidEffectInjectingTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ModifierSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ModifierTagInjectorTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ToolSectionTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.ToolTagInjectorTransformer;
import slimeknights.tconstruct.library.client.book.sectiontransformer.materials.TierRangeMaterialSectionTransformer;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.shared.item.TinkerBookItem;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.SkullStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class TinkerBook
extends BookData {
    public static final BookData MATERIALS_AND_YOU = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.MATERIALS_BOOK_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData PUNY_SMELTING = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.PUNY_SMELTING_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData MIGHTY_SMELTING = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.MIGHTY_SMELTING_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData TINKERS_GADGETRY = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.TINKERS_GADGETRY_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData FANTASTIC_FOUNDRY = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.FANTASTIC_FOUNDRY_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    public static final BookData ENCYCLOPEDIA = BookLoader.registerBook((ResourceLocation)TinkerBookIDs.ENCYCLOPEDIA_ID, (boolean)false, (boolean)false, (BookRepository[])new BookRepository[0]);
    private static final BookData[] ALL_BOOKS = new BookData[]{MATERIALS_AND_YOU, PUNY_SMELTING, MIGHTY_SMELTING, TINKERS_GADGETRY, FANTASTIC_FOUNDRY, ENCYCLOPEDIA};

    public TinkerBook() {
        super(new BookRepository[0]);
    }

    public static void initBook() {
        BookLoader.registerGsonTypeAdapter(Component.class, (Object)new Component.Serializer());
        BookLoader.registerPageType((ResourceLocation)MeleeHarvestMaterialContent.ID, MeleeHarvestMaterialContent.class);
        BookLoader.registerPageType((ResourceLocation)RangedMaterialContent.ID, RangedMaterialContent.class);
        BookLoader.registerPageType((ResourceLocation)ArmorMaterialContent.ID, ArmorMaterialContent.class);
        BookLoader.registerPageType((ResourceLocation)AmmoMaterialContent.ID, ArmorMaterialContent.class);
        BookLoader.registerPageType((ResourceLocation)ContentTool.ID, ContentTool.class);
        BookLoader.registerPageType((ResourceLocation)ContentModifier.ID, ContentModifier.class);
        BookLoader.registerPageType((ResourceLocation)TooltipShowcaseContent.ID, TooltipShowcaseContent.class);
        BookLoader.registerPageType((ResourceLocation)FluidEffectContent.ID, FluidEffectContent.class);
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("melee_harvest"), MeleeHarvestMaterialContent::new, Comparator.comparing(TierRangeMaterialSectionTransformer.hasStatType(HeadMaterialStats.ID)).reversed(), HeadMaterialStats.ID, HandleMaterialStats.ID, StatlessMaterialStats.BINDING.getIdentifier());
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("ranged"), RangedMaterialContent::new, Comparator.comparing(TierRangeMaterialSectionTransformer.hasStatType(StatlessMaterialStats.BOWSTRING)).reversed().thenComparing(TierRangeMaterialSectionTransformer.hasStatType(LimbMaterialStats.ID)), LimbMaterialStats.ID, GripMaterialStats.ID, StatlessMaterialStats.BOWSTRING.getIdentifier());
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("ammo"), AmmoMaterialContent::new, Comparator.comparing(TierRangeMaterialSectionTransformer.hasStatType(StatlessMaterialStats.ARROW_HEAD)).reversed().thenComparing(TierRangeMaterialSectionTransformer.hasStatType(StatlessMaterialStats.FLETCHING)).thenComparing(TierRangeMaterialSectionTransformer.hasStatType(StatlessMaterialStats.ARROW_SHAFT)), StatlessMaterialStats.ARROW_HEAD.getIdentifier(), StatlessMaterialStats.ARROW_SHAFT.getIdentifier(), StatlessMaterialStats.FLETCHING.getIdentifier());
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("armor"), ArmorMaterialContent::new, Comparator.comparing(mat -> {
            MaterialId id;
            IMaterialRegistry registry = MaterialRegistry.getInstance();
            if (registry.getMaterialStats(id = mat.getIdentifier(), StatlessMaterialStats.CUIRASS.getIdentifier()).isPresent()) {
                return registry.getMaterialStats(id, StatlessMaterialStats.MAILLE.getIdentifier()).isPresent() ? 2 : 1;
            }
            if (registry.getMaterialStats(id, PlatingMaterialStats.CHESTPLATE.getId()).isPresent()) {
                return 4;
            }
            return registry.getMaterialStats(id, StatlessMaterialStats.MAILLE.getIdentifier()).isPresent() ? 3 : 5;
        }), PlatingMaterialStats.HELMET.getId(), PlatingMaterialStats.CHESTPLATE.getId(), PlatingMaterialStats.LEGGINGS.getId(), PlatingMaterialStats.BOOTS.getId(), PlatingMaterialStats.SHIELD.getId(), StatlessMaterialStats.MAILLE.getIdentifier(), StatlessMaterialStats.CUIRASS.getIdentifier(), StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        TierRangeMaterialSectionTransformer.registerMaterialType(TConstruct.getResource("skull"), ContentMaterialSkull::new, Comparator.comparing(TierRangeMaterialSectionTransformer.tagOrder(TinkerTags.Materials.SLIMESKULL)), SkullStats.ID);
        ToolSectionTransformer armorTransformer = new ToolSectionTransformer("armor");
        for (BookData book : ALL_BOOKS) {
            book.addTransformer((BookTransformer)ToolTagInjectorTransformer.INSTANCE);
            book.addTransformer((BookTransformer)ModifierTagInjectorTransformer.INSTANCE);
            book.addTransformer((BookTransformer)armorTransformer);
        }
        MATERIALS_AND_YOU.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        MIGHTY_SMELTING.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        TINKERS_GADGETRY.addTransformer((BookTransformer)new ToolSectionTransformer("staffs"));
        TINKERS_GADGETRY.addTransformer((BookTransformer)new ToolSectionTransformer("ancient_tools"));
        ENCYCLOPEDIA.addTransformer((BookTransformer)ToolSectionTransformer.INSTANCE);
        ModifierSectionTransformer upgrades = new ModifierSectionTransformer("upgrades");
        ModifierSectionTransformer defense = new ModifierSectionTransformer("defense");
        ModifierSectionTransformer slotless = new ModifierSectionTransformer("slotless");
        ModifierSectionTransformer abilities = new ModifierSectionTransformer("abilities");
        PUNY_SMELTING.addTransformer((BookTransformer)upgrades);
        PUNY_SMELTING.addTransformer((BookTransformer)slotless);
        MIGHTY_SMELTING.addTransformer((BookTransformer)defense);
        MIGHTY_SMELTING.addTransformer((BookTransformer)abilities);
        ENCYCLOPEDIA.addTransformer((BookTransformer)upgrades);
        ENCYCLOPEDIA.addTransformer((BookTransformer)defense);
        ENCYCLOPEDIA.addTransformer((BookTransformer)slotless);
        ENCYCLOPEDIA.addTransformer((BookTransformer)abilities);
        TinkerBook.addStandardData(MATERIALS_AND_YOU, TinkerBookIDs.MATERIALS_BOOK_ID, new BookTransformer[0]);
        TinkerBook.addStandardData(PUNY_SMELTING, TinkerBookIDs.PUNY_SMELTING_ID, new BookTransformer[0]);
        TinkerBook.addStandardData(MIGHTY_SMELTING, TinkerBookIDs.MIGHTY_SMELTING_ID, new BookTransformer[0]);
        TinkerBook.addStandardData(FANTASTIC_FOUNDRY, TinkerBookIDs.FANTASTIC_FOUNDRY_ID, new BookTransformer[0]);
        TinkerBook.addStandardData(TINKERS_GADGETRY, TinkerBookIDs.TINKERS_GADGETRY_ID, new BookTransformer[0]);
        TinkerBook.addStandardData(ENCYCLOPEDIA, TinkerBookIDs.ENCYCLOPEDIA_ID, FluidEffectInjectingTransformer.INSTANCE);
    }

    private static void addStandardData(BookData book, ResourceLocation id, BookTransformer ... extraTransformers) {
        book.addRepository((BookRepository)new FileRepository(new ResourceLocation(id.m_135827_(), "book/" + id.m_135815_())));
        book.addTransformer(BookTransformer.indexTranformer());
        book.addTransformer((BookTransformer)TierRangeMaterialSectionTransformer.INSTANCE);
        for (BookTransformer transformer : extraTransformers) {
            book.addTransformer(transformer);
        }
        book.addTransformer(BookTransformer.paddingTransformer());
    }

    public static BookData getBook(TinkerBookItem.BookType bookType) {
        return switch (bookType) {
            default -> throw new IncompatibleClassChangeError();
            case TinkerBookItem.BookType.MATERIALS_AND_YOU -> MATERIALS_AND_YOU;
            case TinkerBookItem.BookType.PUNY_SMELTING -> PUNY_SMELTING;
            case TinkerBookItem.BookType.MIGHTY_SMELTING -> MIGHTY_SMELTING;
            case TinkerBookItem.BookType.TINKERS_GADGETRY -> TINKERS_GADGETRY;
            case TinkerBookItem.BookType.FANTASTIC_FOUNDRY -> FANTASTIC_FOUNDRY;
            case TinkerBookItem.BookType.ENCYCLOPEDIA -> ENCYCLOPEDIA;
        };
    }
}

