/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import com.google.common.collect.ImmutableSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.crafting.FireworkStarRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.EntityObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.json.loot.equipment.MobEquipmentManager;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.CrystalClusterBlock;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.block.PiglinHeadBlock;
import slimeknights.tconstruct.world.block.PiglinWallHeadBlock;
import slimeknights.tconstruct.world.block.SlimeDirtBlock;
import slimeknights.tconstruct.world.block.SlimeFungusBlock;
import slimeknights.tconstruct.world.block.SlimeGrassBlock;
import slimeknights.tconstruct.world.block.SlimeLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeNyliumBlock;
import slimeknights.tconstruct.world.block.SlimePropaguleBlock;
import slimeknights.tconstruct.world.block.SlimePropaguleLeavesBlock;
import slimeknights.tconstruct.world.block.SlimeRootsBlock;
import slimeknights.tconstruct.world.block.SlimeSaplingBlock;
import slimeknights.tconstruct.world.block.SlimeTallGrassBlock;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.block.StickySlimeBlock;
import slimeknights.tconstruct.world.data.MobEquipmentProvider;
import slimeknights.tconstruct.world.data.WorldRecipeProvider;
import slimeknights.tconstruct.world.entity.EnderSlimeEntity;
import slimeknights.tconstruct.world.entity.SkySlimeEntity;
import slimeknights.tconstruct.world.entity.SlimePlacementPredicate;
import slimeknights.tconstruct.world.entity.TerracubeEntity;
import slimeknights.tconstruct.world.item.SlimeGrassSeedItem;
import slimeknights.tconstruct.world.worldgen.trees.SlimeTree;

public final class TinkerWorld
extends TinkerModule {
    public static final PlantType SLIME_PLANT_TYPE = PlantType.get((String)"slime");
    public static final RegistryObject<CreativeModeTab> tabWorld = CREATIVE_TABS.register("world", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "world")).m_257737_(() -> new ItemStack(cobaltOre)).m_257501_(TinkerWorld::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerFluids.tabFluids.getId()}).m_257652_());
    public static final ItemObject<Block> cobaltOre = BLOCKS.register("cobalt_ore", () -> new Block(TinkerWorld.builder(MapColor.f_283820_, SoundType.f_56723_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(10.0f)), BLOCK_ITEM);
    public static final ItemObject<Block> rawCobaltBlock = BLOCKS.register("raw_cobalt_block", () -> new Block(TinkerWorld.builder(MapColor.f_283743_, SoundType.f_56723_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(6.0f, 7.0f)), BLOCK_ITEM);
    public static final ItemObject<Item> rawCobalt = ITEMS.register("raw_cobalt", ITEM_PROPS);
    public static final ItemObject<Item> steelShard = ITEMS.register("steel_shard", TOOLTIP_ITEM);
    public static final ItemObject<Item> knightmetalShard = ITEMS.register("knightmetal_shard", TOOLTIP_ITEM);
    public static final ItemObject<Block> steelCluster = BLOCKS.register("steel_cluster", () -> new CrystalClusterBlock(Sounds.SKY_CRYSTAL_CHIME.getSound(), 7, 3, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280606_().m_60955_().m_60977_().m_60978_(2.5f).m_60999_().m_278166_(PushReaction.DESTROY).m_60953_(state -> 5).m_60918_(SoundType.f_56743_)), TOOLTIP_BLOCK_ITEM);
    public static final ItemObject<Block> knightmetalCluster = BLOCKS.register("knightmetal_cluster", () -> new CrystalClusterBlock(Sounds.ENDER_CRYSTAL_CHIME.getSound(), 7, 3, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_280606_().m_60955_().m_60977_().m_60978_(2.5f).m_60999_().m_278166_(PushReaction.DESTROY).m_60953_(state -> 12).m_60918_(SoundType.f_56725_)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<SlimeType, SlimeBlock> slime = Util.make(() -> {
        Function<SlimeType, BlockBehaviour.Properties> slimeProps = type -> TinkerWorld.builder(type.getMapColor(), SoundType.f_56750_).m_60911_(0.8f).m_60918_(SoundType.f_56750_).m_60955_();
        return new EnumObject.Builder(SlimeType.class).put((Enum)SlimeType.EARTH, () -> (SlimeBlock)Blocks.f_50374_).put((Enum)SlimeType.SKY, (Supplier)BLOCKS.register("sky_slime", () -> new StickySlimeBlock((BlockBehaviour.Properties)slimeProps.apply(SlimeType.SKY), (state, other) -> true), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ICHOR, (Supplier)BLOCKS.register("ichor_slime", () -> new StickySlimeBlock(((BlockBehaviour.Properties)slimeProps.apply(SlimeType.ICHOR)).m_60953_(s -> SlimeType.ICHOR.getLightLevel()), (state, other) -> other.m_60734_() != state.m_60734_()), TOOLTIP_BLOCK_ITEM)).put((Enum)SlimeType.ENDER, (Supplier)BLOCKS.register("ender_slime", () -> new StickySlimeBlock((BlockBehaviour.Properties)slimeProps.apply(SlimeType.ENDER), (state, other) -> other.m_60734_() == state.m_60734_()), TOOLTIP_BLOCK_ITEM)).build();
    });
    public static final EnumObject<SlimeType, CongealedSlimeBlock> congealedSlime = BLOCKS.registerEnum(SlimeType.values(), "congealed_slime", type -> new CongealedSlimeBlock(TinkerWorld.builder(type.getMapColor(), SoundType.f_56750_).m_60978_(0.5f).m_60911_(0.5f).m_60953_(s -> type.getLightLevel())), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<DirtType, Block> slimeDirt = BLOCKS.registerEnum(DirtType.TINKER, "slime_dirt", type -> new SlimeDirtBlock(TinkerWorld.builder(type.getMapColor(), SoundType.f_56750_).m_60978_(1.9f)), TOOLTIP_BLOCK_ITEM);
    public static final EnumObject<DirtType, Block> allDirt = new EnumObject.Builder(DirtType.class).put((Enum)DirtType.VANILLA, () -> Blocks.f_50493_).putAll(slimeDirt).build();
    public static final EnumObject<FoliageType, Block> vanillaSlimeGrass;
    public static final EnumObject<FoliageType, Block> earthSlimeGrass;
    public static final EnumObject<FoliageType, Block> skySlimeGrass;
    public static final EnumObject<FoliageType, Block> enderSlimeGrass;
    public static final EnumObject<FoliageType, Block> ichorSlimeGrass;
    public static final Map<DirtType, EnumObject<FoliageType, Block>> slimeGrass;
    public static final EnumObject<FoliageType, SlimeGrassSeedItem> slimeGrassSeeds;
    public static final WoodBlockObject greenheart;
    public static final WoodBlockObject skyroot;
    public static final WoodBlockObject bloodshroom;
    public static final WoodBlockObject enderbark;
    public static final ItemObject<Block> enderbarkRoots;
    public static final EnumObject<SlimeType, Block> slimyEnderbarkRoots;
    public static final EnumObject<FoliageType, SlimeTallGrassBlock> slimeFern;
    public static final EnumObject<FoliageType, SlimeTallGrassBlock> slimeTallGrass;
    public static final EnumObject<FoliageType, FlowerPotBlock> pottedSlimeFern;
    public static final EnumObject<FoliageType, Block> slimeSapling;
    public static final EnumObject<FoliageType, FlowerPotBlock> pottedSlimeSapling;
    public static final EnumObject<FoliageType, Block> slimeLeaves;
    public static final ItemObject<SlimeVineBlock> skySlimeVine;
    public static final ItemObject<SlimeVineBlock> enderSlimeVine;
    public static final GeodeItemObject earthGeode;
    public static final ResourceKey<ConfiguredFeature<?, ?>> configuredEarthGeode;
    public static final ResourceKey<PlacedFeature> placedEarthGeode;
    public static final GeodeItemObject skyGeode;
    public static final ResourceKey<ConfiguredFeature<?, ?>> configuredSkyGeode;
    public static final ResourceKey<PlacedFeature> placedSkyGeode;
    public static final GeodeItemObject ichorGeode;
    public static final ResourceKey<ConfiguredFeature<?, ?>> configuredIchorGeode;
    public static final ResourceKey<PlacedFeature> placedIchorGeode;
    public static final GeodeItemObject enderGeode;
    public static final ResourceKey<ConfiguredFeature<?, ?>> configuredEnderGeode;
    public static final ResourceKey<PlacedFeature> placedEnderGeode;
    public static final ResourceKey<BiomeModifier> spawnEarthGeode;
    public static final ResourceKey<BiomeModifier> spawnSkyGeode;
    public static final ResourceKey<BiomeModifier> spawnIchorGeode;
    public static final ResourceKey<BiomeModifier> spawnEnderGeode;
    public static final EnumObject<TinkerHeadType, SkullBlock> heads;
    public static final EnumObject<TinkerHeadType, WallSkullBlock> wallHeads;
    public static final EnumObject<TinkerHeadType, StandingAndWallBlockItem> headItems;
    public static final EntityObject<SkySlimeEntity> skySlimeEntity;
    public static final EntityObject<EnderSlimeEntity> enderSlimeEntity;
    public static final EntityObject<TerracubeEntity> terracubeEntity;
    public static final ResourceKey<BiomeModifier> spawnOverworldSlime;
    public static final ResourceKey<BiomeModifier> spawnEndSlime;
    public static final RegistryObject<SimpleParticleType> skySlimeParticle;
    public static final RegistryObject<SimpleParticleType> enderSlimeParticle;
    public static final RegistryObject<SimpleParticleType> terracubeParticle;
    public static ResourceKey<BiomeModifier> spawnCobaltOre;
    public static ResourceKey<ConfiguredFeature<?, ?>> configuredSmallCobaltOre;
    public static ResourceKey<PlacedFeature> placedSmallCobaltOre;
    public static ResourceKey<ConfiguredFeature<?, ?>> configuredLargeCobaltOre;
    public static ResourceKey<PlacedFeature> placedLargeCobaltOre;

    public TinkerWorld() {
        MobEquipmentManager.init();
    }

    private static Function<WoodBlockObject.WoodVariant, BlockBehaviour.Properties> createSlimewood(MapColor planks, MapColor bark) {
        return type -> switch (type) {
            case WoodBlockObject.WoodVariant.WOOD -> BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_284180_(bark).m_60918_(SoundType.f_56736_).m_60999_();
            case WoodBlockObject.WoodVariant.LOG -> BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_284495_(state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? planks : bark).m_60918_(SoundType.f_56736_).m_60999_();
            default -> BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASS).m_284180_(planks).m_60918_(SoundType.f_56750_);
        };
    }

    @SubscribeEvent
    void entityAttributes(EntityAttributeCreationEvent event) {
        event.put(skySlimeEntity.get(), Monster.m_33035_().m_22265_());
        event.put(enderSlimeEntity.get(), Monster.m_33035_().m_22265_());
        event.put(terracubeEntity.get(), Monster.m_33035_().m_22265_());
    }

    private static void setWoodFireInfo(FireBlock fireBlock, WoodBlockObject wood) {
        fireBlock.m_53444_((Block)wood.get(), 5, 20);
        fireBlock.m_53444_((Block)wood.getSlab(), 5, 20);
        fireBlock.m_53444_((Block)wood.getStairs(), 5, 20);
        fireBlock.m_53444_((Block)wood.getFence(), 5, 20);
        fireBlock.m_53444_((Block)wood.getFenceGate(), 5, 20);
        fireBlock.m_53444_(wood.getLog(), 5, 5);
        fireBlock.m_53444_(wood.getStrippedLog(), 5, 5);
        fireBlock.m_53444_(wood.getWood(), 5, 5);
        fireBlock.m_53444_(wood.getStrippedWood(), 5, 5);
    }

    @SubscribeEvent
    void registerSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register(EntityType.f_20526_, null, null, new SlimePlacementPredicate(TinkerTags.Blocks.EARTH_SLIME_SPAWN), SpawnPlacementRegisterEvent.Operation.OR);
        event.register(skySlimeEntity.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(TinkerTags.Blocks.SKY_SLIME_SPAWN), SpawnPlacementRegisterEvent.Operation.OR);
        event.register(enderSlimeEntity.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SlimePlacementPredicate(TinkerTags.Blocks.ENDER_SLIME_SPAWN), SpawnPlacementRegisterEvent.Operation.OR);
        event.register(terracubeEntity.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TerracubeEntity::canSpawnHere, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            slimeLeaves.forEach((type, block) -> ComposterBlock.m_51920_((float)(type.isNether() ? 0.85f : 0.35f), (ItemLike)block));
            slimeSapling.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            slimeTallGrass.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            slimeFern.forEach(block -> ComposterBlock.m_51920_((float)0.65f, (ItemLike)block));
            slimeGrassSeeds.forEach(block -> ComposterBlock.m_51920_((float)0.35f, (ItemLike)block));
            ComposterBlock.m_51920_((float)0.5f, skySlimeVine);
            ComposterBlock.m_51920_((float)0.5f, enderSlimeVine);
            ComposterBlock.m_51920_((float)0.4f, enderbarkRoots);
            OptionalDispenseItemBehavior dispenseArmor = new OptionalDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    this.m_123573_(ArmorItem.m_40398_((BlockSource)source, (ItemStack)stack));
                    return stack;
                }
            };
            heads.forEach(arg_0 -> TinkerWorld.lambda$commonSetup$61((DispenseItemBehavior)dispenseArmor, arg_0));
            heads.forEach(head -> FireworkStarRecipe.f_43879_.put(head.m_5456_(), FireworkRocketItem.Shape.CREEPER));
            event.enqueueWork(() -> {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                builder.addAll((Iterable)BlockEntityType.f_58931_.f_58915_);
                heads.forEach(head -> builder.add(head));
                wallHeads.forEach(head -> builder.add(head));
                BlockEntityType.f_58931_.f_58915_ = builder.build();
            });
        });
        event.enqueueWork(() -> {
            FireBlock fireblock = (FireBlock)Blocks.f_50083_;
            BiConsumer<FoliageType, Block> plantFireInfo = (type, block) -> {
                if (!type.isNether()) {
                    fireblock.m_53444_(block, 30, 60);
                }
            };
            slimeLeaves.forEach(plantFireInfo);
            slimeTallGrass.forEach(plantFireInfo);
            slimeFern.forEach(plantFireInfo);
            fireblock.m_53444_((Block)skySlimeVine.get(), 15, 100);
            fireblock.m_53444_((Block)enderSlimeVine.get(), 15, 100);
        });
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        boolean server = event.includeServer();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(server, (DataProvider)new WorldRecipeProvider(packOutput));
        generator.addProvider(server, (DataProvider)new MobEquipmentProvider(packOutput));
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
        output.m_246326_(cobaltOre);
        output.m_246326_(rawCobalt);
        output.m_246326_(rawCobaltBlock);
        output.m_246326_(terracubeEntity);
        output.m_246326_(skySlimeEntity);
        output.m_246326_(enderSlimeEntity);
        output.m_246326_(TinkerMaterials.necroticBone);
        output.m_246326_(TinkerModifiers.dragonScale);
        TinkerWorld.accept(output, headItems);
        output.m_246326_((ItemLike)congealedSlime.get((Enum)SlimeType.EARTH));
        for (SlimeType slimeType : SlimeType.TINKER) {
            output.m_246326_((ItemLike)TinkerCommons.slimeball.get((Enum)slimeType));
            output.m_246326_((ItemLike)slime.get((Enum)slimeType));
            output.m_246326_((ItemLike)congealedSlime.get((Enum)slimeType));
        }
        TinkerWorld.accept(output, (BuildingBlockObject)greenheart);
        output.m_246326_((ItemLike)slimeSapling.get((Enum)FoliageType.EARTH));
        output.m_246326_((ItemLike)slimeLeaves.get((Enum)FoliageType.EARTH));
        TinkerWorld.accept(output, (BuildingBlockObject)skyroot);
        output.m_246326_((ItemLike)slimeSapling.get((Enum)FoliageType.SKY));
        output.m_246326_((ItemLike)slimeLeaves.get((Enum)FoliageType.SKY));
        TinkerWorld.accept(output, (BuildingBlockObject)bloodshroom);
        output.m_246326_((ItemLike)slimeSapling.get((Enum)FoliageType.BLOOD));
        output.m_246326_((ItemLike)slimeLeaves.get((Enum)FoliageType.BLOOD));
        TinkerWorld.accept(output, (BuildingBlockObject)enderbark);
        output.m_246326_((ItemLike)slimeSapling.get((Enum)FoliageType.ENDER));
        output.m_246326_((ItemLike)slimeLeaves.get((Enum)FoliageType.ENDER));
        output.m_246326_(enderbarkRoots);
        TinkerWorld.accept(output, slimyEnderbarkRoots);
        TinkerWorld.accept(output, slimeDirt);
        for (Enum enum_ : FoliageType.VISIBLE) {
            output.m_246326_((ItemLike)slimeTallGrass.get(enum_));
            output.m_246326_((ItemLike)slimeFern.get(enum_));
            if (enum_ == FoliageType.SKY) {
                output.m_246326_(skySlimeVine);
            } else if (enum_ == FoliageType.ENDER) {
                output.m_246326_(enderSlimeVine);
            }
            output.m_246326_((ItemLike)slimeGrassSeeds.get(enum_));
            output.m_246326_((ItemLike)vanillaSlimeGrass.get(enum_));
            output.m_246326_((ItemLike)earthSlimeGrass.get(enum_));
            output.m_246326_((ItemLike)skySlimeGrass.get(enum_));
            output.m_246326_((ItemLike)ichorSlimeGrass.get(enum_));
            output.m_246326_((ItemLike)enderSlimeGrass.get(enum_));
        }
        TinkerWorld.accept(output, earthGeode);
        TinkerWorld.accept(output, skyGeode);
        output.m_246326_(steelShard);
        output.m_246326_(steelCluster);
        TinkerWorld.accept(output, ichorGeode);
        TinkerWorld.accept(output, enderGeode);
        output.m_246326_(knightmetalShard);
        output.m_246326_(knightmetalCluster);
    }

    private static void accept(CreativeModeTab.Output output, GeodeItemObject geode) {
        output.m_246326_((ItemLike)geode);
        output.m_246326_((ItemLike)geode.getBlock());
        output.m_246326_((ItemLike)geode.getBudding());
        for (GeodeItemObject.BudSize size : GeodeItemObject.BudSize.values()) {
            output.m_246326_((ItemLike)geode.getBud(size));
        }
    }

    private static SkullBlock makeHead(TinkerHeadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_278166_(PushReaction.DESTROY);
        if (type.isPiglin()) {
            return new PiglinHeadBlock(type, props);
        }
        return new SkullBlock((SkullBlock.Type)type, props);
    }

    private static WallSkullBlock makeWallHead(TinkerHeadType type) {
        BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).lootFrom(() -> (Block)heads.get((Enum)type));
        if (type.isPiglin()) {
            return new PiglinWallHeadBlock(type, props);
        }
        return new WallSkullBlock((SkullBlock.Type)type, props);
    }

    private static /* synthetic */ void lambda$commonSetup$61(DispenseItemBehavior dispenseArmor, SkullBlock head) {
        DispenserBlock.m_52672_((ItemLike)head, (DispenseItemBehavior)dispenseArmor);
    }

    static {
        slimeGrass = new EnumMap<DirtType, EnumObject<FoliageType, Block>>(DirtType.class);
        Function<FoliageType, BlockBehaviour.Properties> slimeGrassProps = type -> TinkerWorld.builder(type.getMapColor(), SoundType.f_56750_).m_60978_(2.0f).m_60999_().m_60977_();
        Function<FoliageType, Block> slimeGrassRegister = type -> type.isNether() ? new SlimeNyliumBlock((BlockBehaviour.Properties)slimeGrassProps.apply((FoliageType)((Object)type)), (FoliageType)((Object)type)) : new SlimeGrassBlock((BlockBehaviour.Properties)slimeGrassProps.apply((FoliageType)((Object)type)), (FoliageType)((Object)type));
        Enum[] values = FoliageType.values();
        vanillaSlimeGrass = BLOCKS.registerEnum(values, "vanilla_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        earthSlimeGrass = BLOCKS.registerEnum(values, "earth_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        skySlimeGrass = BLOCKS.registerEnum(values, "sky_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        enderSlimeGrass = BLOCKS.registerEnum(values, "ender_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        ichorSlimeGrass = BLOCKS.registerEnum(values, "ichor_slime_grass", slimeGrassRegister, TOOLTIP_BLOCK_ITEM);
        slimeGrass.put(DirtType.VANILLA, vanillaSlimeGrass);
        slimeGrass.put(DirtType.EARTH, earthSlimeGrass);
        slimeGrass.put(DirtType.SKY, skySlimeGrass);
        slimeGrass.put(DirtType.ENDER, enderSlimeGrass);
        slimeGrass.put(DirtType.ICHOR, ichorSlimeGrass);
        slimeGrassSeeds = ITEMS.registerEnum(FoliageType.values(), "slime_grass_seeds", type -> new SlimeGrassSeedItem(ITEM_PROPS, (FoliageType)((Object)type)));
        greenheart = BLOCKS.registerWood("greenheart", TinkerWorld.createSlimewood(MapColor.f_283916_, MapColor.f_283784_), false);
        skyroot = BLOCKS.registerWood("skyroot", TinkerWorld.createSlimewood(MapColor.f_283772_, MapColor.f_283846_), false);
        bloodshroom = BLOCKS.registerWood("bloodshroom", TinkerWorld.createSlimewood(MapColor.f_283913_, MapColor.f_283750_), false);
        enderbark = BLOCKS.registerWood("enderbark", TinkerWorld.createSlimewood(MapColor.f_283927_, MapColor.f_283927_), false);
        enderbarkRoots = BLOCKS.register("enderbark_roots", () -> new SlimeRootsBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_280658_(NoteBlockInstrument.BASS).m_60978_(0.7f).m_60977_().m_60918_(SoundType.f_222467_).m_60955_().m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_60955_()), BLOCK_ITEM);
        slimyEnderbarkRoots = BLOCKS.registerEnum(SlimeType.values(), "enderbark_roots", type -> new SlimeDirtBlock(BlockBehaviour.Properties.m_284310_().m_284180_(type.getMapColor()).m_60978_(0.7f).m_60918_(SoundType.f_222468_).m_60953_(s -> type.getLightLevel())), BLOCK_ITEM);
        Function<Enum, BlockBehaviour.Properties> props = type -> {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_().m_284180_(type.getMapColor());
            if (type.isNether()) {
                properties.m_60918_(SoundType.f_56712_).m_222979_(BlockBehaviour.OffsetType.XZ);
            } else {
                properties.m_60918_(SoundType.f_56740_).m_222979_(BlockBehaviour.OffsetType.XYZ);
            }
            return properties.m_280170_().m_60966_().m_60910_().m_278166_(PushReaction.DESTROY);
        };
        slimeFern = BLOCKS.registerEnum(FoliageType.values(), "slime_fern", type -> new SlimeTallGrassBlock((BlockBehaviour.Properties)props.apply((Enum)type), (FoliageType)((Object)type)), BLOCK_ITEM);
        slimeTallGrass = BLOCKS.registerEnum(FoliageType.values(), "slime_tall_grass", type -> new SlimeTallGrassBlock((BlockBehaviour.Properties)props.apply((Enum)type), (FoliageType)((Object)type)), BLOCK_ITEM);
        pottedSlimeFern = BLOCKS.registerPottedEnum("slime_fern", slimeFern);
        slimeSapling = Util.make(() -> {
            Function<FoliageType, BlockBehaviour.Properties> props = type -> TinkerWorld.builder(type.getMapColor(), type.isNether() ? SoundType.f_56711_ : SoundType.f_56740_).m_60966_().m_60910_().m_278166_(PushReaction.DESTROY);
            return new EnumObject.Builder(FoliageType.class).putAll(BLOCKS.registerEnum(FoliageType.OVERWORLD, "slime_sapling", type -> new SlimeSaplingBlock(new SlimeTree((FoliageType)((Object)((Object)type))), (FoliageType)((Object)((Object)type)), ((BlockBehaviour.Properties)props.apply((FoliageType)((Object)((Object)type)))).m_60977_()), TOOLTIP_BLOCK_ITEM)).put((Enum)FoliageType.BLOOD, (Supplier)BLOCKS.register("blood_slime_sapling", () -> new SlimeFungusBlock((BlockBehaviour.Properties)props.apply(FoliageType.BLOOD), TinkerStructures.bloodSlimeFungus), TOOLTIP_BLOCK_ITEM)).put((Enum)FoliageType.ICHOR, (Supplier)BLOCKS.register("ichor_slime_sapling", () -> new SlimeFungusBlock((BlockBehaviour.Properties)props.apply(FoliageType.ICHOR), TinkerStructures.ichorSlimeFungus), BLOCK_ITEM)).put((Enum)FoliageType.ENDER, (Supplier)BLOCKS.register("ender_slime_sapling", () -> new SlimePropaguleBlock(new SlimeTree(FoliageType.ENDER), FoliageType.ENDER, (BlockBehaviour.Properties)props.apply(FoliageType.ENDER)), TOOLTIP_BLOCK_ITEM)).build();
        });
        pottedSlimeSapling = BLOCKS.registerPottedEnum(FoliageType.values(), "slime_sapling", slimeSapling);
        slimeLeaves = new EnumObject.Builder(FoliageType.class).putAll(BLOCKS.registerEnum(FoliageType.OVERWORLD, "slime_leaves", type -> new SlimeLeavesBlock(TinkerWorld.builder(type.getMapColor(), SoundType.f_56740_).m_60978_(1.0f).m_60977_().m_60955_().m_60922_(Blocks::m_50778_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_278166_(PushReaction.DESTROY).m_60924_(Blocks::m_50805_), (FoliageType)((Object)type)), BLOCK_ITEM)).putAll(BLOCKS.registerEnum(FoliageType.NETHER, "slime_leaves", type -> new Block(TinkerWorld.builder(type.getMapColor(), SoundType.f_56719_).m_60978_(1.5f).m_60922_((s, w, p, e) -> false)), BLOCK_ITEM)).put((Enum)FoliageType.ENDER, (Supplier)BLOCKS.register("ender_slime_leaves", () -> new SlimePropaguleLeavesBlock(TinkerWorld.builder(FoliageType.ENDER.getMapColor(), SoundType.f_56740_).m_60978_(1.0f).m_60977_().m_60955_().m_60922_(Blocks::m_50778_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_278166_(PushReaction.DESTROY).m_60924_(Blocks::m_50805_), FoliageType.ENDER), BLOCK_ITEM)).build();
        props = type -> TinkerWorld.builder(type.getMapColor(), SoundType.f_56740_).m_280170_().m_60978_(0.75f).m_60910_().m_60977_().m_278166_(PushReaction.DESTROY);
        skySlimeVine = BLOCKS.register("sky_slime_vine", () -> new SlimeVineBlock((BlockBehaviour.Properties)props.apply(SlimeType.SKY), SlimeType.SKY), BLOCK_ITEM);
        enderSlimeVine = BLOCKS.register("ender_slime_vine", () -> new SlimeVineBlock((BlockBehaviour.Properties)props.apply(SlimeType.ENDER), SlimeType.ENDER), BLOCK_ITEM);
        earthGeode = BLOCKS.registerGeode("earth_slime_crystal", MapColor.f_283916_, Sounds.EARTH_CRYSTAL, Sounds.EARTH_CRYSTAL_CHIME.getSound(), Sounds.EARTH_CRYSTAL_CLUSTER, 3, ITEM_PROPS);
        configuredEarthGeode = TinkerWorld.key(Registries.f_256911_, "earth_geode");
        placedEarthGeode = TinkerWorld.key(Registries.f_256988_, "earth_geode");
        skyGeode = BLOCKS.registerGeode("sky_slime_crystal", MapColor.f_283743_, Sounds.SKY_CRYSTAL, Sounds.SKY_CRYSTAL_CHIME.getSound(), Sounds.SKY_CRYSTAL_CLUSTER, 0, ITEM_PROPS);
        configuredSkyGeode = TinkerWorld.key(Registries.f_256911_, "sky_geode");
        placedSkyGeode = TinkerWorld.key(Registries.f_256988_, "sky_geode");
        ichorGeode = BLOCKS.registerGeode("ichor_slime_crystal", MapColor.f_283750_, Sounds.ICHOR_CRYSTAL, Sounds.ICHOR_CRYSTAL_CHIME.getSound(), Sounds.ICHOR_CRYSTAL_CLUSTER, 10, ITEM_PROPS);
        configuredIchorGeode = TinkerWorld.key(Registries.f_256911_, "ichor_geode");
        placedIchorGeode = TinkerWorld.key(Registries.f_256988_, "ichor_geode");
        enderGeode = BLOCKS.registerGeode("ender_slime_crystal", MapColor.f_283889_, Sounds.ENDER_CRYSTAL, Sounds.ENDER_CRYSTAL_CHIME.getSound(), Sounds.ENDER_CRYSTAL_CLUSTER, 7, ITEM_PROPS);
        configuredEnderGeode = TinkerWorld.key(Registries.f_256911_, "ender_geode");
        placedEnderGeode = TinkerWorld.key(Registries.f_256988_, "ender_geode");
        spawnEarthGeode = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "earth_geode");
        spawnSkyGeode = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "sky_geode");
        spawnIchorGeode = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "ichor_geode");
        spawnEnderGeode = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "ender_geode");
        heads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "head", TinkerWorld::makeHead);
        wallHeads = BLOCKS.registerEnumNoItem(TinkerHeadType.values(), "wall_head", TinkerWorld::makeWallHead);
        headItems = ITEMS.registerEnum(TinkerHeadType.values(), "head", type -> new StandingAndWallBlockItem((Block)heads.get((Enum)type), (Block)wallHeads.get((Enum)type), new Item.Properties().m_41497_(Rarity.UNCOMMON), Direction.DOWN));
        skySlimeEntity = ENTITIES.registerWithEgg("sky_slime", () -> EntityType.Builder.m_20704_(SkySlimeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(20).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (SkySlimeEntity)skySlimeEntity.get().m_20615_(world)), 4714485, 11337716);
        enderSlimeEntity = ENTITIES.registerWithEgg("ender_slime", () -> EntityType.Builder.m_20704_(EnderSlimeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(32).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (EnderSlimeEntity)enderSlimeEntity.get().m_20615_(world)), 6488240, 13860095);
        terracubeEntity = ENTITIES.registerWithEgg("terracube", () -> EntityType.Builder.m_20704_(TerracubeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(8).m_20699_(2.04f, 2.04f).setCustomClientFactory((spawnEntity, world) -> (TerracubeEntity)terracubeEntity.get().m_20615_(world)), 11516374, 10594225);
        spawnOverworldSlime = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "spawn_overworld_slime");
        spawnEndSlime = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "spawn_end_slime");
        skySlimeParticle = PARTICLE_TYPES.register("sky_slime", () -> new SimpleParticleType(false));
        enderSlimeParticle = PARTICLE_TYPES.register("ender_slime", () -> new SimpleParticleType(false));
        terracubeParticle = PARTICLE_TYPES.register("terracube", () -> new SimpleParticleType(false));
        spawnCobaltOre = TinkerWorld.key(ForgeRegistries.Keys.BIOME_MODIFIERS, "cobalt_ore");
        configuredSmallCobaltOre = TinkerWorld.key(Registries.f_256911_, "cobalt_ore_small");
        placedSmallCobaltOre = TinkerWorld.key(Registries.f_256988_, "cobalt_ore_small");
        configuredLargeCobaltOre = TinkerWorld.key(Registries.f_256911_, "cobalt_ore_large");
        placedLargeCobaltOre = TinkerWorld.key(Registries.f_256988_, "cobalt_ore_large");
    }
}

