/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.recipe;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class CraftingTableRepairKitRecipe
extends CustomRecipe {
    public CraftingTableRepairKitRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    protected boolean toolMatches(ItemStack stack) {
        return stack.m_204117_(TinkerTags.Items.DURABILITY);
    }

    @Nullable
    protected ToolRepair getRelevantInputs(CraftingContainer inv) {
        ItemStack tool = null;
        ItemStack repairKit = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            IRepairKitItem kit;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof IRepairKitItem && (kit = (IRepairKitItem)item).canRepairInCraftingTable()) {
                if (repairKit != null) {
                    return null;
                }
                repairKit = stack;
                continue;
            }
            if (this.toolMatches(stack)) {
                if (tool != null) {
                    return null;
                }
                tool = stack;
                continue;
            }
            return null;
        }
        if (tool == null || repairKit == null) {
            return null;
        }
        return new ToolRepair(tool, repairKit);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ToolRepair inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            return false;
        }
        MaterialId inputMaterial = IMaterialItem.getMaterialFromStack(inputs.repairKit).getId();
        if (inputMaterial.equals(IMaterial.UNKNOWN_ID)) {
            return false;
        }
        ToolStack tool = ToolStack.from(inputs.tool);
        return (tool.isBroken() || tool.getDamage() > 0) && MaterialRepairToolHook.canRepairWith(tool, inputMaterial);
    }

    protected float getRepairAmount(IToolStackView tool, ItemStack repairStack) {
        return MaterialRepairToolHook.repairAmount(tool, IMaterialItem.getMaterialFromStack(repairStack).getId());
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        float f;
        ToolRepair inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ToolStack.from(inputs.tool);
        float repairAmount = this.getRepairAmount(tool, inputs.repairKit);
        if (repairAmount <= 0.0f) {
            return ItemStack.f_41583_;
        }
        Item item = inputs.repairKit.m_41720_();
        if (item instanceof IRepairKitItem) {
            IRepairKitItem kit = (IRepairKitItem)item;
            f = kit.getRepairAmount();
        } else {
            f = ((Double)Config.COMMON.repairKitAmount.get()).floatValue();
        }
        repairAmount *= f / 3.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairAmount = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
            if (!(repairAmount <= 0.0f)) continue;
            return ItemStack.f_41583_;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, (int)repairAmount);
        return tool.copyStack(inputs.tool);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.craftingTableRepairSerializer.get();
    }

    protected record ToolRepair(ItemStack tool, ItemStack repairKit) {
    }
}

