/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.ModelData;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.shared.block.entity.TableBlockEntity;

public abstract class RetexturedTableBlockEntity
extends TableBlockEntity
implements IRetexturedBlockEntity {
    private static final String TAG_TEXTURE = "texture";
    @Nonnull
    protected Block texture = Blocks.f_50016_;

    public RetexturedTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, Component name, int size) {
        super(type, pos, state, name, size);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 2, 1));
    }

    @Nonnull
    public ModelData getModelData() {
        return RetexturedHelper.getModelData((Block)this.texture);
    }

    public String getTextureName() {
        return RetexturedHelper.getTextureName((Block)this.texture);
    }

    private void textureUpdated() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            Block normalizedTexture = this.texture == Blocks.f_50016_ ? null : this.texture;
            ModelData data = this.getModelData();
            if (data.get(RetexturedHelper.BLOCK_PROPERTY) != normalizedTexture) {
                this.requestModelDataUpdate();
                BlockState state = this.m_58900_();
                this.f_58857_.m_7260_(this.f_58858_, state, state, 0);
            }
        }
    }

    public void updateTexture(String name) {
        Block oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            this.textureUpdated();
        }
    }

    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.texture != Blocks.f_50016_) {
            tags.m_128359_(TAG_TEXTURE, this.getTextureName());
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_(TAG_TEXTURE, 8)) {
            this.texture = RetexturedHelper.getBlock((String)tags.m_128461_(TAG_TEXTURE));
            this.textureUpdated();
        }
    }

    @Nonnull
    public Block getTexture() {
        return this.texture;
    }
}

