/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;

@ApiStatus.Internal
public enum SmelteryCompat {
    TIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTin, CompatType.ORE),
    ALUMINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenAluminum, CompatType.ORE),
    LEAD((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLead, CompatType.ORE),
    SILVER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSilver, CompatType.ORE),
    NICKEL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNickel, CompatType.ORE),
    ZINC((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenZinc, CompatType.ORE),
    PLATINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPlatinum, CompatType.ORE),
    TUNGSTEN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTungsten, CompatType.ORE),
    OSMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenOsmium, CompatType.ORE),
    URANIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenUranium, CompatType.ORE),
    CHROMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenChromium, CompatType.ORE),
    CADMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenCadmium, CompatType.ORE),
    BRONZE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBronze, "tin"),
    BRASS((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBrass, "zinc"),
    ELECTRUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenElectrum, "silver"),
    INVAR((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenInvar, "nickel"),
    CONSTANTAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenConstantan, "nickel"),
    PEWTER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPewter, "tin", "lead"),
    ENDERIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenEnderium, CompatType.ALLOY),
    LUMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLumium, CompatType.ALLOY),
    SIGNALUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSignalum, CompatType.ALLOY),
    REFINED_GLOWSTONE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedGlowstone, CompatType.ALLOY),
    REFINED_OBSIDIAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedObsidian, CompatType.ALLOY),
    NICROSIL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNicrosil, CompatType.ALLOY),
    DURALUMIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenDuralumin, CompatType.ALLOY),
    BENDALLOY((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBendalloy, CompatType.ALLOY),
    STEELEAF((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSteeleaf, CompatType.NONE),
    FIERY((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.fieryLiquid, CompatType.ALLOY);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final CompatType type;
    @Deprecated
    private final String[] tags;

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, CompatType type) {
        this.fluid = fluid;
        this.type = type;
        this.tags = new String[0];
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, String ... altTags) {
        this.fluid = fluid;
        this.type = CompatType.ALLOY;
        this.tags = altTags;
    }

    @Deprecated(forRemoval=true)
    public boolean isOre() {
        return this.type == CompatType.ORE;
    }

    @Deprecated(forRemoval=true)
    public String getAltTag() {
        return this.tags.length == 0 ? "" : this.tags[0];
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public boolean isPresent() {
        if (SmelteryCompat.ingotPresent(this.name)) {
            return true;
        }
        if (this.tags.length > 0 && ((Boolean)Config.COMMON.allowIngotlessAlloys.get()).booleanValue()) {
            for (String tag : this.tags) {
                if (!SmelteryCompat.ingotPresent(tag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean ingotPresent(String name) {
        Optional tag = BuiltInRegistries.f_257033_.m_203431_(ItemTags.create((ResourceLocation)Mantle.commonResource((String)("ingots/" + name))));
        return tag.isPresent() && ((HolderSet.Named)tag.get()).m_203632_() > 0;
    }

    public String getName() {
        return this.name;
    }

    public CompatType getType() {
        return this.type;
    }

    @Deprecated
    public String[] getTags() {
        return this.tags;
    }

    public static enum CompatType {
        ORE,
        ALLOY,
        NONE;

    }
}

