/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.material;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.recipe.material.MaterialsCraftingTableRecipe;
import slimeknights.tconstruct.library.recipe.material.ShapelessMaterialsRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialsCraftingExtension<T extends CraftingRecipe & MaterialsCraftingTableRecipe>
implements ICraftingCategoryExtension {
    protected final T recipe;
    private final ItemStack plainResult;
    private final List<ItemStack> result;
    @Nullable
    private final int[] materialSlots;

    public MaterialsCraftingExtension(T recipe) {
        Item item;
        this.recipe = recipe;
        this.plainResult = recipe.m_8043_(Objects.requireNonNull(SafeClientAccess.getRegistryAccess()));
        if (((MaterialsCraftingTableRecipe)recipe).getPartCount() == 1) {
            Ingredient firstPart = ((MaterialsCraftingTableRecipe)recipe).getParts().get(0);
            this.result = Arrays.stream(firstPart.m_43908_()).map(variant -> {
                ItemStack stack = this.plainResult.m_41777_();
                Item patt2250$temp = variant.m_41720_();
                if (patt2250$temp instanceof IMaterialItem) {
                    IMaterialItem materialItem = (IMaterialItem)patt2250$temp;
                    ((MaterialsCraftingTableRecipe)recipe).setMaterial(stack, materialItem.getMaterial((ItemStack)variant));
                } else {
                    ((MaterialsCraftingTableRecipe)recipe).setMaterial(stack, MaterialRecipeCache.findRecipe(variant).getMaterial().getVariant());
                }
                return stack;
            }).toList();
            this.materialSlots = this.getMaterialSlots(recipe, firstPart);
        } else if (((MaterialsCraftingTableRecipe)recipe).getExtraMaterials().isEmpty() && (item = this.plainResult.m_41720_()) instanceof IMaterialItem) {
            IMaterialItem materialItem = (IMaterialItem)item;
            this.result = List.of(materialItem.setMaterialForced(this.plainResult, ToolBuildHandler.getRenderMaterial(0)));
            this.materialSlots = null;
        } else {
            this.result = List.of(IModifiableDisplay.getDisplayStack(this.plainResult));
            this.materialSlots = null;
        }
    }

    @Nullable
    public static MaterialsCraftingExtension<ShapelessMaterialsRecipe> shapeless(ShapelessMaterialsRecipe recipe) {
        NonNullList parts = recipe.m_7527_();
        for (int i = 0; i < recipe.getPartCount(); ++i) {
            if (((Ingredient)parts.get(i)).m_43908_().length != 0) continue;
            return null;
        }
        return new MaterialsCraftingExtension<ShapelessMaterialsRecipe>(recipe);
    }

    protected int[] getMaterialSlots(T recipe, Ingredient firstPart) {
        return new int[]{0};
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.m_6423_();
    }

    public static void setRecipe(ICraftingCategoryExtension self, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, CraftingRecipe recipe, List<ItemStack> result, ItemStack plainResult, @Nullable int[] materialSlots) {
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(plainResult);
        List<List> inputStacks = recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        int width = self.getWidth();
        int height = self.getHeight();
        if (width <= 0 || height <= 0) {
            width = height = MaterialsCraftingExtension.getShapelessSize(inputStacks.size());
            builder.setShapeless();
        }
        List inputs = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, inputStacks, width, height);
        IRecipeSlotBuilder output = craftingGridHelper.createAndSetOutputs(builder, result);
        if (inputs.size() != 9) {
            Mantle.logger.error("Failed to create focus link for {} as the layout {} is not 3x3", (Object)recipe.m_6423_(), (Object)builder.getClass().getName());
        } else if (materialSlots != null) {
            int finalWidth = width;
            int finalHeight = height;
            builder.createFocusLink((IIngredientAcceptor[])Streams.concat((Stream[])new Stream[]{Stream.of(output), Arrays.stream(materialSlots).mapToObj(i -> (IRecipeSlotBuilder)inputs.get(MaterialsCraftingExtension.getCraftingIndex(i, finalWidth, finalHeight)))}).toArray(IRecipeSlotBuilder[]::new));
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        MaterialsCraftingExtension.setRecipe(this, builder, craftingGridHelper, this.recipe, this.result, this.plainResult, this.materialSlots);
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }

    private static int getShapelessSize(int total) {
        if (total > 4) {
            return 3;
        }
        if (total > 1) {
            return 2;
        }
        return 1;
    }
}

