/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.entities.illager.EngineerIllager;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class ImmersiveEngineeringPlugin {
    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        ChemthrowerHandler.registerEffect(TinkerTags.Fluids.CHEMTHROWER_BOTH_EFFECTS, (ChemthrowerHandler.ChemthrowerEffect)new FluidEffectChemThrowerEffect(true, true));
        ChemthrowerHandler.registerEffect(TinkerTags.Fluids.CHEMTHROWER_BLOCK_EFFECTS, (ChemthrowerHandler.ChemthrowerEffect)new FluidEffectChemThrowerEffect(true, false));
        ChemthrowerHandler.registerEffect(TinkerTags.Fluids.CHEMTHROWER_ENTITY_EFFECTS, (ChemthrowerHandler.ChemthrowerEffect)new FluidEffectChemThrowerEffect(false, true));
        event.enqueueWork(() -> ModifierUtil.registerShieldDisabler(entity -> {
            EngineerIllager illager;
            if (entity instanceof EngineerIllager && (illager = (EngineerIllager)entity).m_21254_()) {
                illager.disableShield();
            }
        }, (EntityType)IEEntityTypes.BULWARK.get(), (EntityType)IEEntityTypes.COMMANDO.get(), (EntityType)IEEntityTypes.FUSILIER.get()));
    }

    private static class FluidEffectChemThrowerEffect
    extends ChemthrowerHandler.ChemthrowerEffect {
        private final boolean runBlock;
        private final boolean runEntity;

        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
        }

        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, Fluid fluid) {
        }

        private static void consumeProjectiles(List<ChemthrowerShotEntity> projectiles, float consumed, double projectileValue) {
            if (consumed > 0.0f) {
                for (ChemthrowerShotEntity projectile : projectiles) {
                    projectile.m_146870_();
                    if (!((consumed = (float)((double)consumed - projectileValue)) <= 0.0f)) continue;
                    break;
                }
            }
        }

        public void applyToEntity(LivingEntity target, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            if (!this.runEntity) {
                return;
            }
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            if (!recipe.hasEntityEffects()) {
                return;
            }
            List projectiles = target.m_9236_().m_45976_(ChemthrowerShotEntity.class, target.m_20191_());
            if (projectiles.isEmpty()) {
                return;
            }
            double projectileValue = (Double)Config.COMMON.chemthrowerShotValue.get();
            int amount = (int)(projectileValue * (double)projectiles.size());
            if (amount > 0) {
                float consumed = recipe.applyToEntity(new FluidStack(fluid, amount), 1.0f, FluidEffectContext.builder(target.m_9236_()).user(shooter).stack(thrower).target(target), IFluidHandler.FluidAction.EXECUTE);
                FluidEffectChemThrowerEffect.consumeProjectiles(projectiles, consumed, projectileValue);
            }
        }

        private static AABB makeAABB(BlockPos start, BlockPos end) {
            return new AABB((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_(), (double)(end.m_123341_() + 1), (double)(end.m_123342_() + 1), (double)(end.m_123343_() + 1));
        }

        public void applyToBlock(Level world, HitResult mop, @Nullable Player shooter, ItemStack thrower, FluidStack fluid) {
            if (!this.runBlock || mop.m_6662_() != HitResult.Type.BLOCK) {
                return;
            }
            FluidEffects recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid());
            if (!recipe.hasBlockEffects()) {
                return;
            }
            BlockHitResult hitResult = (BlockHitResult)mop;
            Direction direction = hitResult.m_82434_();
            BlockPos pos = hitResult.m_82425_();
            BlockPos offset = pos.m_121945_(direction);
            AABB aabb = direction.m_122421_() == Direction.AxisDirection.NEGATIVE ? FluidEffectChemThrowerEffect.makeAABB(offset, pos) : FluidEffectChemThrowerEffect.makeAABB(pos, offset);
            List projectiles = world.m_45976_(ChemthrowerShotEntity.class, aabb);
            if (projectiles.isEmpty()) {
                return;
            }
            double projectileValue = (Double)Config.COMMON.chemthrowerShotValue.get();
            int amount = (int)(projectileValue * (double)projectiles.size());
            if (amount > 0) {
                float consumed = recipe.applyToBlock(new FluidStack(fluid, amount), 1.0f, FluidEffectContext.builder(world).user(shooter).stack(thrower).block(hitResult), IFluidHandler.FluidAction.EXECUTE);
                FluidEffectChemThrowerEffect.consumeProjectiles(projectiles, consumed, projectileValue);
            }
        }

        public FluidEffectChemThrowerEffect(boolean runBlock, boolean runEntity) {
            this.runBlock = runBlock;
            this.runEntity = runEntity;
        }
    }
}

