/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.part;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.library.utils.DomainDisplayName;
import slimeknights.tconstruct.library.utils.Util;

public class MaterialItem
extends Item
implements IMaterialItem {
    private static final String ADDED_BY = TConstruct.makeTranslationKey("tooltip", "part.added_by");

    public MaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static MaterialVariantId getMaterialId(@Nullable CompoundTag nbt) {
        MaterialVariantId id;
        String str;
        if (nbt != null && !(str = nbt.m_128461_("Material")).isEmpty() && (id = MaterialVariantId.tryParse(str)) != null) {
            return id;
        }
        return IMaterial.UNKNOWN_ID;
    }

    @Override
    public MaterialVariantId getMaterial(ItemStack stack) {
        return MaterialItem.getMaterialId(stack.m_41783_());
    }

    @Nullable
    private static Component getName(String baseKey, MaterialVariantId material) {
        ResourceLocation location = material.getLocation('.');
        String fullKey = String.format("%s.%s.%s", baseKey, location.m_135827_(), location.m_135815_());
        if (Util.canTranslate(fullKey)) {
            return Component.m_237115_((String)fullKey);
        }
        String materialKey = MaterialTooltipCache.getKey(material);
        String materialPrefix = materialKey + ".format";
        if (Util.canTranslate(materialPrefix)) {
            return Component.m_237110_((String)materialPrefix, (Object[])new Object[]{Component.m_237115_((String)baseKey)});
        }
        if (Util.canTranslate(materialKey)) {
            return Component.m_237110_((String)TooltipUtil.KEY_FORMAT, (Object[])new Object[]{Component.m_237115_((String)materialKey), Component.m_237115_((String)baseKey)});
        }
        return null;
    }

    public static Component getName(IMaterialItem self, ItemStack stack) {
        Component component;
        MaterialVariantId material = self.getMaterial(stack);
        String key = self.m_5456_().m_5671_(stack);
        if (material.equals(IMaterial.UNKNOWN_ID)) {
            return Component.m_237115_((String)key);
        }
        if (material.hasVariant() && (component = MaterialItem.getName(key, material)) != null) {
            return component;
        }
        component = MaterialItem.getName(key, material.getId());
        if (component != null) {
            return component;
        }
        return Component.m_237115_((String)key);
    }

    public Component m_7626_(ItemStack stack) {
        return MaterialItem.getName(this, stack);
    }

    public static void appendHoverText(IMaterialItem self, ItemStack stack, List<Component> tooltip, TooltipFlag flag) {
        MaterialVariantId materialVariant;
        if (flag.m_7050_() && !TooltipUtil.isDisplay(stack) && !(materialVariant = self.getMaterial(stack)).equals(IMaterial.UNKNOWN_ID)) {
            tooltip.add((Component)Component.m_237110_((String)ToolPartItem.MATERIAL_KEY, (Object[])new Object[]{materialVariant.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        MaterialItem.appendHoverText(this, stack, tooltip, flag);
    }

    public static String getCreatorModId(IMaterialItem self, ItemStack stack) {
        String namespace;
        MaterialVariantId material = self.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material) && !"tconstruct".equals(namespace = material.getId().m_135827_())) {
            return namespace;
        }
        return BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135827_();
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        return MaterialItem.getCreatorModId(this, stack);
    }

    @Deprecated(forRemoval=true)
    protected static void addModTooltip(IMaterial material, List<Component> tooltip) {
        if (material != IMaterial.UNKNOWN) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237110_((String)ADDED_BY, (Object[])new Object[]{DomainDisplayName.nameFor(material.getIdentifier().m_135827_())}));
        }
    }

    public static void verifyTag(CompoundTag nbt) {
        MaterialId resolved;
        MaterialId original;
        MaterialVariantId id = MaterialItem.getMaterialId(nbt);
        if (!id.equals(IMaterial.UNKNOWN_ID) && (original = id.getId()) != (resolved = MaterialRegistry.getInstance().resolve(original))) {
            nbt.m_128359_("Material", MaterialVariantId.create(resolved, id.getVariant()).toString());
        }
    }

    public void m_142312_(CompoundTag nbt) {
        MaterialItem.verifyTag(nbt);
    }
}

