/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeBuilder
extends AbstractRecipeBuilder<MaterialRecipeBuilder> {
    private final MaterialVariantId material;
    private Ingredient ingredient = Ingredient.f_43901_;
    private int value = 1;
    private int needed = 1;
    private ItemOutput leftover = ItemOutput.EMPTY;

    public MaterialRecipeBuilder setIngredient(TagKey<Item> tag) {
        return this.setIngredient(Ingredient.m_204132_(tag));
    }

    public MaterialRecipeBuilder setIngredient(ItemLike item) {
        return this.setIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public MaterialRecipeBuilder setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, this.material.getId());
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        if (this.material == null) {
            throw new IllegalStateException("recipe " + id + " has no material associated with it");
        }
        if (this.ingredient == Ingredient.f_43901_) {
            throw new IllegalStateException("recipe " + id + " must have ingredient set");
        }
        if (this.value <= 0) {
            throw new IllegalStateException("recipe " + id + " has no value associated with it");
        }
        if (this.needed <= 0) {
            throw new IllegalStateException("recipe " + id + " has no needed associated with it");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "materials");
        consumerIn.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MaterialRecipe(id, this.group, this.ingredient, this.value, this.needed, this.material, this.leftover), MaterialRecipe.LOADER, advancementId));
    }

    private MaterialRecipeBuilder(MaterialVariantId material) {
        this.material = material;
    }

    public static MaterialRecipeBuilder materialRecipe(MaterialVariantId material) {
        return new MaterialRecipeBuilder(material);
    }

    public MaterialRecipeBuilder setValue(int value) {
        this.value = value;
        return this;
    }

    public MaterialRecipeBuilder setNeeded(int needed) {
        this.needed = needed;
        return this;
    }

    public MaterialRecipeBuilder setLeftover(ItemOutput leftover) {
        this.leftover = leftover;
        return this;
    }
}

