/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.PotionCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.TippingCastingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class TipClearingCastingRecipe
extends PotionCastingRecipe {
    public static final RecordLoadable<TipClearingCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, TippingCastingRecipe.TOOL_FIELD, (RecordField)FLUID_FIELD, (RecordField)COOLING_TIME_FIELD, (RecordField)ModifierId.PARSER.requiredField("modifier", r -> r.modifier), TipClearingCastingRecipe::new);
    private final ModifierId modifier;

    public TipClearingCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient tool, FluidIngredient fluid, int coolingTime, ModifierId modifier) {
        super(serializer, id, group, tool, fluid, Items.f_41852_, coolingTime);
        this.modifier = modifier;
    }

    @Override
    public boolean matches(ICastingContainer inv, Level level) {
        ItemStack stack = inv.getStack();
        return super.matches(inv, level) && ModifierUtil.getModifierLevel(stack, this.modifier) > 0 && !ModifierUtil.getPersistentString(stack, this.modifier).isEmpty();
    }

    @Override
    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack result = inv.getStack().m_41777_();
        ToolStack.from(result).getPersistentData().remove(this.modifier);
        return result;
    }

    @Override
    public List<DisplayCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> tools = Arrays.stream(this.bottle.m_43908_()).map(stack -> IDisplayModifierRecipe.withModifiers(IModifiableDisplay.getDisplayStack(stack), List.of(new ModifierEntry(this.modifier, 1)))).toList();
            List<ItemStack> toolWithPotion = BuiltInRegistries.f_256980_.m_123024_().filter(potion -> potion != Potions.f_43598_).flatMap(potion -> {
                String id = Loadables.POTION.getString(potion);
                return tools.stream().map(stack -> {
                    ToolStack tool = ToolStack.copyFrom(stack);
                    tool.getPersistentData().putString(this.modifier, id);
                    return tool.copyStack((ItemStack)stack);
                });
            }).toList();
            List<ItemStack> toolWithoutPotion = ForgeRegistries.POTIONS.getValues().stream().filter(potion -> potion != Potions.f_43598_).flatMap(i -> tools.stream()).toList();
            this.displayRecipes = List.of(new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), toolWithPotion, (List<FluidStack>)this.fluid.getFluids(), toolWithoutPotion, this.coolingTime, true));
        }
        return this.displayRecipes;
    }
}

