/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import java.util.Set;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.loot.LootModifierManager;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.RegistryLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialManager;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.library.utils.GsonLoadable;

public class TinkerLoadables {
    public static final StringLoadable<AttributeModifier.Operation> OPERATION = new EnumLoadable(AttributeModifier.Operation.class);
    public static final StringLoadable<EquipmentSlot> EQUIPMENT_SLOT = new EnumLoadable(EquipmentSlot.class);
    public static final Loadable<Set<EquipmentSlot>> EQUIPMENT_SLOT_SET = EQUIPMENT_SLOT.set();
    public static final StringLoadable<ArmorItem.Type> ARMOR_SLOT = new EnumLoadable(ArmorItem.Type.class);
    public static final StringLoadable<LightLayer> LIGHT_LAYER = new EnumLoadable(LightLayer.class);
    public static final StringLoadable<InteractionSource> INTERACTION_SOURCE = new EnumLoadable(InteractionSource.class);
    public static final StringLoadable<IMeltingContainer.OreRateType> ORE_RATE_TYPE = new EnumLoadable(IMeltingContainer.OreRateType.class);
    public static final StringLoadable<TooltipKey> TOOLTIP_KEY = new EnumLoadable(TooltipKey.class);
    public static final StringLoadable<ResourceLocation> CUSTOM_STAT = new RegistryLoadable(BuiltInRegistries.f_256771_);
    public static final StringLoadable<RecipeType<?>> RECIPE_TYPE = new RegistryLoadable(BuiltInRegistries.f_256990_);
    public static final StringLoadable<TagKey<Modifier>> MODIFIER_TAGS = Loadables.tagKey(ModifierManager.REGISTRY_KEY);
    public static final StringLoadable<TagKey<IMaterial>> MATERIAL_TAGS = Loadables.tagKey(MaterialManager.REGISTRY_KEY);
    public static final StringLoadable<IMaterialItem> MATERIAL_ITEM = TinkerLoadables.instance(Loadables.ITEM, IMaterialItem.class, "Expected item to be instance of IMaterialItem");
    public static final StringLoadable<IModifiable> MODIFIABLE_ITEM = TinkerLoadables.instance(Loadables.ITEM, IModifiable.class, "Expected item to be instance of IModifiable");
    public static final StringLoadable<IToolPart> TOOL_PART_ITEM = TinkerLoadables.instance(Loadables.ITEM, IToolPart.class, "Expected item to be instance of IToolPart");
    public static final StringLoadable<SimpleParticleType> SIMPLE_PARTICLE = TinkerLoadables.instance(Loadables.PARTICLE_TYPE, SimpleParticleType.class, "Expected particle type to be instance of SimpleParticleType");
    public static final StringLoadable<Tier> TIER = Loadables.RESOURCE_LOCATION.xmap((id, error) -> {
        Tier tier = TierSortingRegistry.byName((ResourceLocation)id);
        if (tier != null) {
            return tier;
        }
        throw error.create("Unknown harvest tier " + id);
    }, (tier, error) -> {
        ResourceLocation id = TierSortingRegistry.getName((Tier)tier);
        if (id != null) {
            return id;
        }
        throw error.create("Attempt to serialize unregistered tier " + tier);
    });
    public static final Loadable<LootPoolEntryContainer> LOOT_ENTRY = new GsonLoadable<LootPoolEntryContainer>(LootModifierManager.GSON_INSTANCE, LootPoolEntryContainer.class);

    public static <B, T> StringLoadable<T> instance(StringLoadable<B> loadable, Class<T> typeClass, String errorMsg) {
        return loadable.comapFlatMap((base, error) -> {
            if (typeClass.isInstance(base)) {
                return typeClass.cast(base);
            }
            throw error.create(errorMsg);
        }, t -> t);
    }
}

