/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.OverslimeModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record OvershieldModule(float protection, int consumed) implements ModifierModule,
ProtectionModifierHook,
TooltipModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROTECTION, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<OvershieldModule> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.requiredField("protection", OvershieldModule::protection), (RecordField)IntLoadable.FROM_ONE.requiredField("consumed", OvershieldModule::consumed), OvershieldModule::new);

    public RecordLoadable<OvershieldModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        int overslime;
        if (DamageSourcePredicate.CAN_PROTECT.matches((Object)source) && (overslime = OverslimeModule.INSTANCE.getAmount(tool)) > 0) {
            int consumed = Math.min(overslime, this.consumed);
            modifierValue += this.protection * (float)consumed / (float)consumed;
            OverslimeModule.INSTANCE.removeAmount(tool, consumed);
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float protection = this.protection;
        if (tooltipKey == TooltipKey.SHIFT) {
            int overslime = OverslimeModule.INSTANCE.getAmount(tool);
            if (overslime == 0) {
                return;
            }
            protection *= (float)Math.min(overslime, this.consumed) / (float)this.consumed;
        }
        ProtectionModule.addResistanceTooltip(tool, modifier.getModifier(), protection, player, tooltip);
    }
}

