/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.interaction;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.eventbus.api.Event;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.AreaOfEffectHighlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ShowOffhandModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class HarvestAbilityModifier
extends NoLevelsModifier
implements BlockInteractionModifierHook,
AreaOfEffectHighlightModifierHook {
    private final int priority;

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(ShowOffhandModule.DISALLOW_BROKEN);
        hookBuilder.addHook(this, ModifierHooks.BLOCK_INTERACT, ModifierHooks.AOE_HIGHLIGHT);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.priority > Short.MIN_VALUE;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return InteractionSource.formatModifierName(tool, this, super.getDisplayName(tool, entry, access));
    }

    private static boolean harvestInteract(UseOnContext context, ServerLevel world, BlockState state, BlockPos pos, @Nullable Player player) {
        if (player == null) {
            return false;
        }
        BlockHitResult trace = new BlockHitResult(context.m_43720_(), context.m_43719_(), pos, false);
        InteractionResult result = state.m_60664_((Level)world, player, context.m_43724_(), trace);
        return result.m_19077_();
    }

    private static boolean harvestStackable(ServerLevel world, BlockState state, BlockPos pos, @Nullable Player player) {
        if (world.m_8055_(pos.m_7495_()).m_60734_() == state.m_60734_()) {
            world.m_46953_(pos, true, (Entity)player);
            return true;
        }
        BlockPos up = pos.m_7494_();
        if (world.m_8055_(up).m_60734_() == state.m_60734_()) {
            world.m_46953_(up, true, (Entity)player);
            return true;
        }
        return false;
    }

    private static boolean harvestCrop(ItemStack stack, ServerLevel world, BlockState state, BlockPos pos, @Nullable Player player) {
        BlockState replant;
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crops = (CropBlock)block;
            if (!crops.m_52307_(state)) {
                return false;
            }
            replant = crops.m_52289_(0);
        } else {
            IntegerProperty age = null;
            for (Property prop : state.m_61147_()) {
                if (!prop.m_61708_().equals("age") || !(prop instanceof IntegerProperty)) continue;
                age = (IntegerProperty)prop;
                break;
            }
            if (age == null) {
                return false;
            }
            Collection allowedValues = age.m_6908_();
            if (!allowedValues.contains(0)) {
                return false;
            }
            int maxAge = age.m_6908_().stream().max(Integer::compareTo).orElse(Integer.MAX_VALUE);
            if ((Integer)state.m_61143_((Property)age) < maxAge) {
                return false;
            }
            replant = (BlockState)state.m_61124_((Property)age, (Comparable)Integer.valueOf(0));
        }
        List drops = Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)stack);
        Iterator iterator = drops.iterator();
        boolean hasSeed = false;
        while (iterator.hasNext()) {
            ItemStack drop = (ItemStack)iterator.next();
            if (!drop.m_204117_(TinkerTags.Items.SEEDS)) continue;
            hasSeed = true;
            drop.m_41774_(1);
            if (!drop.m_41619_()) break;
            iterator.remove();
            break;
        }
        if (hasSeed) {
            world.m_46597_(pos, replant);
            state.m_222967_(world, pos, stack, true);
            world.m_5594_(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            world.m_46961_(pos, false);
        }
        for (ItemStack drop : drops) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
        }
        return true;
    }

    private static boolean harvest(UseOnContext context, IToolStackView tool, ServerLevel world, BlockState state, BlockPos pos, InteractionSource source) {
        Player player = context.m_43723_();
        Holder.Reference holder = state.m_60734_().m_204297_();
        if (!holder.m_203656_(TinkerTags.Blocks.HARVESTABLE)) {
            return false;
        }
        boolean didHarvest = false;
        Event.Result result = new TinkerToolEvent.ToolHarvestEvent(tool, context, world, state, pos, source).fire();
        if (result != Event.Result.DEFAULT) {
            didHarvest = result == Event.Result.ALLOW;
        } else if (holder.m_203656_(TinkerTags.Blocks.HARVESTABLE_INTERACT)) {
            didHarvest = HarvestAbilityModifier.harvestInteract(context, world, state, pos, player);
        } else if (holder.m_203656_(TinkerTags.Blocks.HARVESTABLE_STACKABLE)) {
            didHarvest = HarvestAbilityModifier.harvestStackable(world, state, pos, player);
        } else if (holder.m_203656_(TinkerTags.Blocks.HARVESTABLE_CROPS)) {
            didHarvest = HarvestAbilityModifier.harvestCrop(context.m_43722_(), world, state, pos, player);
        }
        if (didHarvest) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.PLANT_HARVEST).afterHarvest(tool, entry, context, world, state, pos);
            }
        }
        return didHarvest;
    }

    @Override
    public boolean shouldHighlight(IToolStackView tool, ModifierEntry modifier, UseOnContext context, BlockPos offset, BlockState state) {
        return state.m_204336_(TinkerTags.Blocks.HARVESTABLE);
    }

    @Override
    public InteractionResult beforeBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        BlockPos pos;
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (state.m_204336_(TinkerTags.Blocks.HARVESTABLE)) {
            if (world instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)world;
                boolean survival = player == null || !player.m_7500_();
                boolean didHarvest = false;
                boolean broken = false;
                ItemStack stack = context.m_43722_();
                if (HarvestAbilityModifier.harvest(context, tool, server, state, pos, source)) {
                    didHarvest = true;
                    boolean bl = broken = survival && ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack);
                }
                if (!broken && player != null) {
                    for (BlockPos newPos : tool.getHook(ToolHooks.AOE_ITERATOR).getBlocks(tool, context, state, AreaOfEffectIterator.AOEMatchType.TRANSFORM)) {
                        if (!HarvestAbilityModifier.harvest(context, tool, server, world.m_8055_(newPos), newPos, source)) continue;
                        didHarvest = true;
                        if (!survival || !ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) continue;
                        broken = true;
                        break;
                    }
                }
                if (player != null) {
                    if (didHarvest) {
                        player.m_36346_();
                    }
                    if (broken) {
                        player.m_21190_(context.m_43724_());
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public HarvestAbilityModifier(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

