/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.tools.part.IRepairKitItem;
import slimeknights.tconstruct.library.tools.part.block.MaterialBlockItem;
import slimeknights.tconstruct.tools.item.FakeIngotItem;

public class FakeStorageBlockItem
extends MaterialBlockItem
implements IRepairKitItem {
    private final Object2BooleanArrayMap<MaterialId> missingItemCache = new Object2BooleanArrayMap();
    private final Predicate<MaterialId> missingItemGetter = material -> FakeIngotItem.hasItem(material, this.getRepairAmount());
    private final int repairAmount;
    private final TagKey<IMaterial> validMaterials;

    public FakeStorageBlockItem(Block block, Item.Properties properties, int repairAmount, TagKey<IMaterial> validMaterials) {
        super(block, properties);
        this.repairAmount = repairAmount;
        this.validMaterials = validMaterials;
        RecipeCacheInvalidator.addReloadListener(client -> this.missingItemCache.clear());
    }

    @Override
    public float getRepairAmount() {
        return this.repairAmount;
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        if (registry.isInTag(material, this.validMaterials)) {
            return this.missingItemCache.computeIfAbsent((Object)material, this.missingItemGetter);
        }
        return false;
    }

    @Override
    public boolean canRepairInCraftingTable() {
        return false;
    }
}

