/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;

@ApiStatus.Internal
public record UpdateFluidEffectsPacket(List<FluidEffects.Entry> fluids) implements IThreadsafePacket
{
    public static UpdateFluidEffectsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ArrayList<FluidEffects.Entry> entries = new ArrayList<FluidEffects.Entry>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            FluidEffects effects = (FluidEffects)FluidEffects.LOADABLE.decode(buffer, FluidEffectManager.contextBuilder(key).build());
            entries.add(new FluidEffects.Entry(key, effects));
        }
        return new UpdateFluidEffectsPacket(List.copyOf(entries));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.fluids.size());
        for (FluidEffects.Entry entry : this.fluids) {
            buffer.m_130085_(entry.name());
            FluidEffects.LOADABLE.encode(buffer, (Object)entry.effects());
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        FluidEffectManager.INSTANCE.updateFromServer(this.fluids);
    }
}

