/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;

public class StructureUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final BlockPos minPos;
    private final BlockPos maxPos;
    private final List<BlockPos> tanks;

    public StructureUpdatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.minPos = buffer.m_130135_();
        this.maxPos = buffer.m_130135_();
        int count = buffer.m_130242_();
        this.tanks = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.tanks.add(buffer.m_130135_());
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130064_(this.minPos);
        buffer.m_130064_(this.maxPos);
        buffer.m_130130_(this.tanks.size());
        for (BlockPos tank : this.tanks) {
            buffer.m_130064_(tank);
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    public StructureUpdatePacket(BlockPos pos, BlockPos minPos, BlockPos maxPos, List<BlockPos> tanks) {
        this.pos = pos;
        this.minPos = minPos;
        this.maxPos = maxPos;
        this.tanks = tanks;
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(StructureUpdatePacket packet) {
            BlockEntityHelper.get(HeatingStructureBlockEntity.class, (BlockGetter)Minecraft.m_91087_().f_91073_, (BlockPos)packet.pos).ifPresent(te -> te.setStructureSize(packet.minPos, packet.maxPos, packet.tanks));
        }
    }
}

