/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged.common;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileFuseModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;

public record ProjectileAttractMobsModule(LevelingValue radius, LevelingValue strength) implements ModifierModule,
ProjectileHitModifierHook,
ProjectileFuseModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_FUSE);
    public static final RecordLoadable<ProjectileAttractMobsModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("radius", ProjectileAttractMobsModule::radius), (RecordField)LevelingValue.LOADABLE.requiredField("strength", ProjectileAttractMobsModule::strength), ProjectileAttractMobsModule::new);

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private void pullMobs(ModifierEntry entry, Projectile projectile, Vec3 origin) {
        double x = origin.f_82479_;
        double y = origin.f_82480_;
        double z = origin.f_82481_;
        float level = entry.getEffectiveLevel();
        float range = this.radius.compute(level);
        List targets = projectile.m_9236_().m_45976_(LivingEntity.class, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        int pulled = 0;
        float strength = this.strength.compute(level);
        for (LivingEntity target : targets) {
            if (target.m_213877_() || target.m_20182_().m_82557_(origin) < 0.25) continue;
            Vec3 knockback = new Vec3(x - target.m_20185_(), y - target.m_20186_(), z - target.m_20189_());
            knockback = knockback.m_82490_((double)strength * Math.pow(knockback.m_82556_(), -0.25));
            target.m_5997_(knockback.f_82479_, knockback.f_82480_, knockback.f_82481_);
            if (target instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)target;
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(player.m_19879_(), player.m_20184_()));
            }
            if (++pulled <= 25) continue;
            break;
        }
        if (pulled > 0 && !projectile.m_6095_().m_204039_(TinkerTags.EntityTypes.REUSABLE_AMMO)) {
            projectile.m_146870_();
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, boolean notBlocked) {
        this.pullMobs(modifier, projectile, hit.m_82450_());
        return false;
    }

    @Override
    public boolean onProjectileHitsBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity owner) {
        this.pullMobs(modifier, projectile, hit.m_82450_());
        return false;
    }

    @Override
    public void onProjectileFuseFinish(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow) {
        this.pullMobs(modifier, projectile, projectile.m_20182_());
    }
}

