/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.gadgets.entity.EFLNExplosion;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.fluid.entity.DamageFluidEffect;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileFuseModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.CustomExplosion;

public record ProjectileExplosionModule(LevelingValue radius, float eflnBonus, LevelingValue knockback, boolean placeFire, Explosion.BlockInteraction blockInteraction) implements ModifierModule,
ProjectileHitModifierHook,
ProjectileFuseModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_HIT_CLIENT, ModifierHooks.PROJECTILE_FUSE);
    public static final RecordLoadable<ProjectileExplosionModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("radius", ProjectileExplosionModule::radius), (RecordField)FloatLoadable.FROM_ZERO.defaultField("efln_bonus", (Object)Float.valueOf(0.0f), false, ProjectileExplosionModule::eflnBonus), (RecordField)LevelingValue.LOADABLE.defaultField("knockback", (Object)LevelingValue.flat(1.0f), true, ProjectileExplosionModule::knockback), (RecordField)BooleanLoadable.INSTANCE.defaultField("place_fire", Boolean.valueOf(false), ProjectileExplosionModule::placeFire), (RecordField)new EnumLoadable(Explosion.BlockInteraction.class).requiredField("block_interaction", ProjectileExplosionModule::blockInteraction), ProjectileExplosionModule::new);
    public static final ResourceLocation EFLN = TConstruct.getResource("efln");

    public static Builder radius(float flat, float perLevel) {
        return new Builder(new LevelingValue(flat, perLevel));
    }

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private boolean explode(ModifierEntry modifier, Projectile projectile, ModDataNBT persistentData, Vec3 location) {
        float level = modifier.getEffectiveLevel();
        float radius = this.radius.computeForLevel(level);
        if (radius > 0.5f && !projectile.m_6095_().m_204039_(TinkerTags.EntityTypes.REUSABLE_AMMO)) {
            Level world = projectile.m_9236_();
            if (!world.f_46443_) {
                float power = ProjectileWithPower.getDamage(projectile);
                Entity cause = projectile.m_19749_();
                DamageFluidEffect.DamageTypePair damageType = cause != null ? TinkerDamageTypes.MOB_EXPLOSION : TinkerDamageTypes.EXPLOSION;
                DamageSource damageSource = CombatHelper.damageSource(damageType.ranged(), (Entity)projectile, (Entity)cause);
                ModifierUtil.updateFishingRod(projectile, 2 + 3 * modifier.getLevel(), true);
                projectile.m_146870_();
                CustomExplosion explosion = persistentData.getBoolean(EFLN) ? new EFLNExplosion(world, location, radius + this.eflnBonus, (Entity)projectile, power, damageSource, this.knockback.computeForScale(level), this.placeFire, this.blockInteraction) : new CustomExplosion(world, location, radius, (Entity)projectile, null, power, damageSource, this.knockback.computeForScale(level), null, this.placeFire, this.blockInteraction);
                explosion.handleServer();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onProjectileHitsBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity owner) {
        return this.explode(modifier, projectile, persistentData, hit.m_82450_());
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, boolean notBlocked) {
        return this.explode(modifier, projectile, persistentData, hit.m_82450_());
    }

    @Override
    public void onProjectileFuseFinish(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow) {
        this.explode(modifier, projectile, persistentData, projectile.m_20182_());
    }

    @CanIgnoreReturnValue
    public static class Builder {
        private final LevelingValue radius;
        private float eflnBonus = 0.0f;
        private LevelingValue knockback = LevelingValue.flat(1.0f);
        private boolean placeFire = false;
        private Explosion.BlockInteraction blockInteraction = Explosion.BlockInteraction.DESTROY_WITH_DECAY;

        public Builder ignoreBlocks() {
            return this.blockInteraction(Explosion.BlockInteraction.KEEP);
        }

        public Builder noBlockDecay() {
            return this.blockInteraction(Explosion.BlockInteraction.DESTROY);
        }

        public Builder placeFire() {
            return this.placeFire(true);
        }

        @CheckReturnValue
        public ProjectileExplosionModule build() {
            return new ProjectileExplosionModule(this.radius, this.eflnBonus, this.knockback, this.placeFire, this.blockInteraction);
        }

        private Builder(LevelingValue radius) {
            this.radius = radius;
        }

        public Builder eflnBonus(float eflnBonus) {
            this.eflnBonus = eflnBonus;
            return this;
        }

        public Builder knockback(LevelingValue knockback) {
            this.knockback = knockback;
            return this;
        }

        public Builder placeFire(boolean placeFire) {
            this.placeFire = placeFire;
            return this;
        }

        public Builder blockInteraction(Explosion.BlockInteraction blockInteraction) {
            this.blockInteraction = blockInteraction;
            return this;
        }
    }
}

