/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class DyedModifierModel
implements IBakedModifierModel {
    public static final IUnbakedModifierModel UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
        Material smallTexture = (Material)smallGetter.apply("");
        Material largeTexture = (Material)largeGetter.apply("");
        if (smallTexture != null || largeTexture != null) {
            return new DyedModifierModel(smallTexture, largeTexture);
        }
        return null;
    };
    @Nullable
    private final Material small;
    @Nullable
    private final Material large;

    @Override
    @Nullable
    public Object getCacheKey(IToolStackView tool, ModifierEntry entry) {
        ModifierId modifier = entry.getId();
        ModDataNBT data = tool.getPersistentData();
        int color = -1;
        if (data.contains(modifier, 3)) {
            color = data.getInt(modifier);
        }
        return new CacheKey(modifier, color);
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        ModifierId key;
        ModDataNBT data;
        Material texture;
        Material material = texture = isLarge ? this.large : this.small;
        if (texture != null && (data = tool.getPersistentData()).contains(key = modifier.getId(), 3)) {
            quadConsumer.accept(MantleItemLayerModel.getQuadsForSprite((int)(0xFF000000 | data.getInt(key)), (int)-1, (TextureAtlasSprite)spriteGetter.apply(texture), (Transformation)transforms, (int)0, (ItemLayerPixels)pixels));
        }
    }

    public DyedModifierModel(@Nullable Material small, @Nullable Material large) {
        this.small = small;
        this.large = large;
    }

    private record CacheKey(ModifierId modifier, int color) {
    }
}

