/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class TippedToolTransformRecipe
extends ToolBuildingRecipe {
    public static final RecordLoadable<TippedToolTransformRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)RESULT_FIELD, (RecordField)LAYOUT_FIELD, (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("input", r -> (Ingredient)r.ingredients.get(0)), (RecordField)MaterialVariantId.LOADABLE.list(0).defaultField("materials", List.of(), false, r -> r.materials), (RecordField)ModifierId.PARSER.requiredField("modifier", r -> r.modifier), TippedToolTransformRecipe::new);
    protected final ModifierId modifier;

    public TippedToolTransformRecipe(ResourceLocation id, String group, IModifiable output, @Nullable ResourceLocation layoutSlot, Ingredient ingredient, List<MaterialVariantId> materials, ModifierId modifier) {
        super(id, group, output, 1, layoutSlot, List.of(ingredient), List.of(), materials);
        this.modifier = modifier;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.tippedToolTransformRecipeSerializer.get();
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool;
        RecipeResult<LazyToolStack> result = super.getValidatedResult(inv, access);
        if (result.isSuccess() && (tool = result.getResult().getTool()).getModifierLevel(this.modifier) > 0) {
            CompoundTag tag;
            ItemStack stack = ItemStack.f_41583_;
            for (int i = 0; i < inv.getInputCount() && (stack = inv.getInput(i)).m_41619_(); ++i) {
            }
            if (!stack.m_41619_() && (tag = stack.m_41783_()) != null && tag.m_128425_("Potion", 8)) {
                tool.getPersistentData().putString(this.modifier, tag.m_128461_("Potion"));
            }
        }
        return result;
    }

    @Override
    public List<ItemStack> getDisplayOutput() {
        if (this.displayOutput == null) {
            ItemStack result = super.getDisplayOutput().get(0);
            this.displayOutput = Arrays.stream(((Ingredient)this.ingredients.get(0)).m_43908_()).map(stack -> {
                CompoundTag tag = stack.m_41783_();
                if (tag != null) {
                    ItemStack copy = result.m_41777_();
                    ToolStack.from(copy).getPersistentData().putString(this.modifier, tag.m_128461_("Potion"));
                    return copy;
                }
                return result;
            }).toList();
        }
        return this.displayOutput;
    }
}

