/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.CastingRecipeLookup;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.PartSwapCastingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class ToolCastingRecipe
extends PartSwapCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    public static final RecordLoadable<ToolCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, (RecordField)ITEM_COST_FIELD, (RecordField)new EnumLoadable(CastPurpose.class).defaultField("cast_purpose", (Object)CastPurpose.MAYBE_MATERIAL, true, r -> r.castPurpose), (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.result), (RecordField)MATERIALS_FIELD, (RecordField)MaterialVariantId.LOADABLE.list(0).defaultField("extra_materials", List.of(), false, r -> r.extraMaterials), ToolCastingRecipe::new);
    private final IModifiable result;
    private final CastPurpose castPurpose;
    private final List<MaterialVariantId> extraMaterials;

    protected ToolCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, CastPurpose castPurpose, IModifiable result, IJsonPredicate<MaterialVariantId> allowedMaterials, List<MaterialVariantId> extraMaterials) {
        super(serializer, id, group, cast, itemCost, castPurpose.swapIndex, allowedMaterials);
        this.result = result;
        this.castPurpose = castPurpose;
        this.extraMaterials = extraMaterials;
        CastingRecipeLookup.registerCastable(result);
    }

    @Deprecated(forRemoval=true)
    public ToolCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IModifiable result) {
        this(serializer, id, group, cast, itemCost, CastPurpose.MAYBE_MATERIAL, result, MaterialPredicate.ANY, List.of());
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        if (inv.getStack().m_41720_() != this.result.m_5456_()) {
            return MaterialCastingLookup.getCastingFluid(inv.getFluid(), (IJsonPredicate<MaterialVariantId>)this.materials);
        }
        return super.getFluidRecipe(inv);
    }

    @Override
    public boolean matches(ICastingContainer inv, Level level) {
        ItemStack cast = inv.getStack();
        if (cast.m_41720_() == this.result.m_5456_()) {
            return this.canPartSwap(inv);
        }
        if (!this.getCast().test(cast)) {
            return false;
        }
        List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
        MaterialFluidRecipe recipe = this.getFluidRecipe(inv);
        return recipe != MaterialFluidRecipe.EMPTY && requirements.get(this.castPurpose == CastPurpose.MAYBE_MATERIAL ? requirements.size() - 1 : this.castPurpose.swapIndex).canUseMaterial(recipe.getOutput().getId());
    }

    @Override
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    @Override
    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack cast = inv.getStack();
        if (cast.m_41720_() == this.result) {
            return super.assemble(inv, access);
        }
        MaterialVariant fluidMaterial = this.getFluidRecipe(inv).getOutput();
        MaterialNBT.Builder materials = MaterialNBT.builder();
        if (this.castPurpose == CastPurpose.SECOND_MATERIAL) {
            materials.add(fluidMaterial);
        }
        if (this.castPurpose == CastPurpose.FIRST_MATERIAL || this.castPurpose == CastPurpose.SECOND_MATERIAL || this.castPurpose == CastPurpose.MAYBE_MATERIAL && ToolMaterialHook.stats(this.result.getToolDefinition()).size() > 1) {
            materials.add(IMaterialItem.getMaterialFromStack(cast));
        }
        if (this.castPurpose != CastPurpose.SECOND_MATERIAL) {
            materials.add(fluidMaterial);
        }
        materials.add(this.extraMaterials);
        return ToolBuildHandler.buildItemFromMaterials(this.result, materials.build());
    }

    @Override
    public boolean isConsumed(ICastingContainer inv) {
        return this.castPurpose != CastPurpose.CATALYST || inv.getStack().m_41720_() == this.result.m_5456_();
    }

    @Override
    public List<IDisplayableCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
            if (requirements.isEmpty()) {
                this.multiRecipes = List.of();
            } else {
                BiFunction<MaterialVariant, List, List> materials;
                boolean first;
                MaterialStatsId requirement;
                MaterialVariant dummyRequirement = MaterialVariant.of(ToolBuildHandler.getRenderMaterial(0));
                MaterialNBT.Builder partSwapMaterials = new MaterialNBT.Builder();
                CastPurpose castPurpose = this.castPurpose;
                if (castPurpose == CastPurpose.MAYBE_MATERIAL) {
                    castPurpose = requirements.size() > 1 ? CastPurpose.FIRST_MATERIAL : CastPurpose.CONSUMED;
                    requirement = requirements.get(requirements.size() - 1);
                } else {
                    requirement = castPurpose == CastPurpose.FIRST_MATERIAL && requirements.size() > 1 ? requirements.get(1) : requirements.get(0);
                }
                boolean bl = first = castPurpose == CastPurpose.FIRST_MATERIAL;
                if (first || castPurpose == CastPurpose.SECOND_MATERIAL) {
                    MaterialVariant castMaterial = MaterialVariant.of(MaterialRegistry.firstWithStatType(requirements.get(1 - castPurpose.swapIndex)));
                    materials = (mat, casts) -> casts.stream().map(cast -> {
                        MaterialVariantId id;
                        MaterialNBT.Builder builder = MaterialNBT.builder();
                        if (!first) {
                            builder.add((MaterialVariant)mat);
                        }
                        builder.add((id = IMaterialItem.getMaterialFromStack(cast)) == IMaterial.UNKNOWN_ID ? castMaterial : MaterialVariant.of(id));
                        if (first) {
                            builder.add((MaterialVariant)mat);
                        }
                        return ToolBuildHandler.buildItemFromMaterials(this.result, builder.add(this.extraMaterials).build());
                    }).toList();
                    if (first) {
                        partSwapMaterials.add(castMaterial).add(dummyRequirement);
                    } else {
                        partSwapMaterials.add(dummyRequirement).add(castMaterial);
                    }
                } else {
                    materials = (mat, casts) -> List.of(ToolBuildHandler.buildItemFromMaterials(this.result, MaterialNBT.builder().add((MaterialVariant)mat).add(this.extraMaterials).build()));
                    partSwapMaterials.add(dummyRequirement);
                }
                ItemStack partSwapDisplay = ToolBuildHandler.buildItemFromMaterials(this.result, partSwapMaterials.add(this.extraMaterials).build());
                partSwapDisplay.m_41784_().m_128379_("tic_display", true);
                List<ItemStack> casts2 = List.of(this.getCast().m_43908_());
                boolean consumed = castPurpose != CastPurpose.CATALYST;
                List<ItemStack> castsWithTool = consumed ? Streams.concat((Stream[])new Stream[]{casts2.stream(), Stream.of(partSwapDisplay)}).toList() : casts2;
                List<ItemStack> partSwapList = consumed ? List.of() : List.of(partSwapDisplay);
                ArrayList<DisplayCastingRecipe> recipes = new ArrayList<DisplayCastingRecipe>();
                Predicate<MaterialFluidRecipe> validRecipe = recipe -> {
                    MaterialVariant output = recipe.getOutput();
                    return recipe.isVisible() && requirement.canUseMaterial(output.getId()) && this.materials.matches((Object)output.getVariant());
                };
                List<MaterialFluidRecipe> validCasting = MaterialCastingLookup.getAllCastingFluids().stream().filter(validRecipe).toList();
                for (MaterialFluidRecipe recipe2 : validCasting) {
                    List<FluidStack> fluids = this.resizeFluids(recipe2.getFluids());
                    int amount = this.itemCost * ToolCastingRecipe.getFluidAmount(fluids);
                    recipes.add(new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), castsWithTool, fluids, materials.apply(recipe2.getOutput(), castsWithTool), ICastingRecipe.calcCoolingTime(recipe2.getTemperature(), amount), consumed));
                    if (consumed) continue;
                    recipes.add(new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), partSwapList, fluids, materials.apply(recipe2.getOutput(), partSwapList), ICastingRecipe.calcCoolingTime(recipe2.getTemperature(), amount), true));
                }
                MaterialCastingLookup.getAllCompositeFluids().stream().filter(validRecipe).map(recipe -> {
                    List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                    return new DisplayCastingRecipe(this.m_6423_(), this.m_6671_(), (List<ItemStack>)((List)materials.apply(recipe.getInput(), casts2)), fluids, (List)materials.apply(recipe.getOutput(), casts2), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * ToolCastingRecipe.getFluidAmount(fluids)), true);
                }).forEach(recipes::add);
                this.multiRecipes = List.copyOf(recipes);
            }
        }
        return this.multiRecipes;
    }

    public static enum CastPurpose {
        MAYBE_MATERIAL(-1),
        CATALYST(0),
        CONSUMED(0),
        FIRST_MATERIAL(1),
        SECOND_MATERIAL(0);

        private final int swapIndex;

        private CastPurpose(int swapIndex) {
            this.swapIndex = swapIndex;
        }
    }
}

