/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public class ModifiableItemClientExtension
implements IClientItemExtensions {
    private static final float PI = (float)Math.PI;
    public static final ModifiableItemClientExtension INSTANCE = new ModifiableItemClientExtension();

    protected ModifiableItemClientExtension() {
    }

    private static void applyItemArmTransform(PoseStack poseStack, float equippedProgress, int sideOffset) {
        poseStack.m_252880_((float)sideOffset * 0.56f, -0.52f + equippedProgress * -0.6f, -0.72f);
    }

    public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack stack, float partialTicks, float equipProgress, float swingProgress) {
        int sideOffset;
        InteractionHand hand = arm == player.m_5737_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        int n = sideOffset = arm == HumanoidArm.RIGHT ? 1 : -1;
        if (player.m_6117_() && player.m_21212_() > 0 && player.m_7655_() == hand) {
            switch (stack.m_41780_()) {
                case NONE: 
                case BLOCK: {
                    ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
                    break;
                }
                case EAT: 
                case DRINK: {
                    float timeLeft = (float)player.m_21212_() - partialTicks + 1.0f;
                    float percentage = timeLeft / (float)stack.m_41779_();
                    if (percentage < 0.8f) {
                        poseStack.m_252880_(0.0f, Mth.m_14154_((float)(Mth.m_14089_((float)(timeLeft / 4.0f * (float)Math.PI)) * 0.1f)), 0.0f);
                    }
                    float speed = 1.0f - (float)Math.pow(percentage, 27.0);
                    int sideOffset1 = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.m_252880_(speed * 0.6f * (float)sideOffset1, speed * -0.5f, speed * 0.0f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)sideOffset1 * speed * 90.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(speed * 10.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)sideOffset1 * speed * 30.0f));
                    ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
                    break;
                }
                case BOW: {
                    ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
                    poseStack.m_252880_((float)sideOffset * -0.2785682f, 0.18344387f, 0.15731531f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-13.935f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)sideOffset * 35.3f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)sideOffset * -9.785f));
                    float remainingTime = (float)stack.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f);
                    float charge = remainingTime / (float)ModifierUtil.getPersistentInt(stack, GeneralInteractionModifierHook.KEY_DRAWTIME, 20);
                    charge = (charge * charge + charge * 2.0f) / 3.0f;
                    if (charge > 1.0f) {
                        charge = 1.0f;
                    }
                    if (charge > 0.1f) {
                        poseStack.m_252880_(0.0f, Mth.m_14031_((float)((remainingTime - 0.1f) * 1.3f)) * (charge - 0.1f) * 0.004f, 0.0f);
                    }
                    poseStack.m_252880_(0.0f, 0.0f, charge * 0.04f);
                    poseStack.m_85841_(1.0f, 1.0f, 1.0f + charge * 0.2f);
                    poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(sideOffset * 45)));
                    break;
                }
                case SPEAR: {
                    ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
                    poseStack.m_252880_((float)sideOffset * -0.5f, 0.7f, 0.1f);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)sideOffset * 35.3f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_((float)sideOffset * -9.785f));
                    float sRemainingTime = (float)stack.m_41779_() - ((float)player.m_21212_() - partialTicks + 1.0f);
                    float sCharge = sRemainingTime / (float)ModifierUtil.getPersistentInt(stack, GeneralInteractionModifierHook.KEY_DRAWTIME, 20);
                    if (sCharge > 1.0f) {
                        sCharge = 1.0f;
                    }
                    if (sCharge > 0.1f) {
                        poseStack.m_252880_(0.0f, Mth.m_14031_((float)((sRemainingTime - 0.1f) * 1.3f)) * (sCharge - 0.1f) * 0.004f, 0.0f);
                    }
                    poseStack.m_252880_(0.0f, 0.0f, sCharge * 0.2f);
                    poseStack.m_85841_(1.0f, 1.0f, 1.0f + sCharge * 0.2f);
                    poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(sideOffset * 45)));
                    break;
                }
                case BRUSH: {
                    ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
                    float xRot = -15.0f + 75.0f * Mth.m_14089_((float)((1.0f - ((float)(player.m_21212_() % 10) - partialTicks + 1.0f) / 10.0f) * 2.0f * (float)Math.PI));
                    if (arm != HumanoidArm.RIGHT) {
                        poseStack.m_85837_(0.1, 0.83, 0.35);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
                        poseStack.m_85837_(-0.3, 0.22, 0.35);
                        break;
                    }
                    poseStack.m_85837_(-0.25, 0.22, 0.35);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-80.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
                }
            }
        } else if (player.m_21209_()) {
            ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
            poseStack.m_252880_((float)sideOffset * -0.4f, 0.8f, 0.3f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(sideOffset * 65)));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(sideOffset * -85)));
        } else {
            poseStack.m_252880_((float)sideOffset * -0.4f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI)), 0.2f * Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI * 2.0f)), -0.2f * Mth.m_14031_((float)(swingProgress * (float)Math.PI)));
            ModifiableItemClientExtension.applyItemArmTransform(poseStack, equipProgress, sideOffset);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)sideOffset * (45.0f + Mth.m_14031_((float)(swingProgress * swingProgress * (float)Math.PI)) * -20.0f)));
            float rotation = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)sideOffset * rotation * -20.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation * -80.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(sideOffset * -45)));
        }
        return true;
    }
}

