/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import slimeknights.mantle.recipe.data.IRecipeHelper;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipeBuilder;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;

public interface IMaterialRecipeHelper
extends IRecipeHelper {
    default public void materialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Ingredient input, int value, int needed, String saveName) {
        this.materialRecipe(consumer, material, input, value, needed, null, saveName);
    }

    default public void materialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Ingredient input, int value, int needed, @Nullable ItemOutput leftover, String saveName) {
        MaterialRecipeBuilder builder = MaterialRecipeBuilder.materialRecipe(material).setIngredient(input).setValue(value).setNeeded(needed);
        if (leftover != null) {
            builder.setLeftover(leftover);
        }
        builder.save(consumer, this.location(saveName));
    }

    default public void metalMaterialRecipe(Consumer<FinishedRecipe> consumer, MaterialVariantId material, String folder, String name, boolean optional) {
        Consumer wrapped = optional ? this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + name)}) : consumer;
        String matName = material.getLocation('/').m_135815_();
        TagKey ingotTag = this.getItemTag("forge", "ingots/" + name);
        this.materialRecipe(wrapped, material, Ingredient.m_204132_((TagKey)ingotTag), 1, 1, folder + matName + "/ingot");
        wrapped = optional ? this.withCondition(consumer, new ICondition[]{this.tagCondition("nuggets/" + name)}) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.m_204132_((TagKey)this.getItemTag("forge", "nuggets/" + name)), 1, 9, folder + matName + "/nugget");
        wrapped = optional ? this.withCondition(consumer, new ICondition[]{this.tagCondition("storage_blocks/" + name)}) : consumer;
        this.materialRecipe(wrapped, material, Ingredient.m_204132_((TagKey)this.getItemTag("forge", "storage_blocks/" + name)), 9, 1, ItemOutput.fromTag((TagKey)ingotTag), folder + matName + "/block");
    }

    default public void materialMelting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, Fluid fluid, int fluidAmount, String folder) {
        MaterialMeltingRecipeBuilder.material(material, fluid, fluidAmount).save(consumer, this.location(folder + "melting/" + material.getLocation('_').m_135815_()));
    }

    default public void materialMelting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, int fluidAmount, String folder) {
        MaterialMeltingRecipeBuilder.material(material, fluid, fluidAmount).save(consumer, this.location(folder + "melting/" + material.getLocation('_').m_135815_()));
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, int fluidAmount, String folder) {
        MaterialFluidRecipeBuilder.material(material).setFluid(fluid.ingredient(fluidAmount)).setTemperature(IMeltingRecipe.getTemperature(fluid)).save(consumer, this.location(folder + "casting/" + material.getLocation('_').m_135815_()));
        this.materialMelting(consumer, material, fluid, fluidAmount, folder);
    }

    default public void materialMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialVariantId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(consumer, material, fluid, 90, folder);
    }

    default public void compatMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, String altTag, String folder) {
        this.materialMeltingCasting(this.withCondition(consumer, new ICondition[]{new OrCondition(new ICondition[]{this.tagCondition("ingots/" + material.m_135815_()), this.tagCondition("ingots/" + altTag)})}), material, fluid, folder);
    }

    default public void compatMeltingCasting(Consumer<FinishedRecipe> consumer, MaterialId material, FluidObject<?> fluid, String folder) {
        this.materialMeltingCasting(this.withCondition(consumer, new ICondition[]{this.tagCondition("ingots/" + material.m_135815_())}), material, fluid, folder);
    }

    default public void materialMeltingComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, int amount, String folder) {
        this.materialMelting(consumer, output, fluid, amount, folder);
        this.materialComposite(consumer, input, output, fluid, amount, folder);
    }

    default public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, int amount, String folder, String name) {
        MaterialFluidRecipeBuilder.material(output).setInputId(input).setFluid(fluid.ingredient(amount)).setTemperature(IMeltingRecipe.getTemperature(fluid)).save(consumer, this.location(folder + "composite/" + name));
    }

    default public void materialComposite(Consumer<FinishedRecipe> consumer, MaterialVariantId input, MaterialVariantId output, FluidObject<?> fluid, int amount, String folder) {
        this.materialComposite(consumer, input, output, fluid, amount, folder, output.getLocation('_').m_135815_());
    }
}

