/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.building;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.building.ToolBuildingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IToolPart;
import slimeknights.tconstruct.tools.recipe.TippedToolTransformRecipe;

public class ToolBuildingRecipeBuilder
extends AbstractRecipeBuilder<ToolBuildingRecipeBuilder> {
    private final IModifiable output;
    private int outputSize = 1;
    @Nullable
    private ResourceLocation layoutSlot = null;
    private final List<Ingredient> extraRequirements = new ArrayList<Ingredient>();
    private List<IToolPart> partsOverride = null;
    private final List<MaterialVariantId> extraMaterials = new ArrayList<MaterialVariantId>();
    @Nullable
    private ModifierId tippedModifier = null;

    public ToolBuildingRecipeBuilder addExtraRequirement(Ingredient ingredient) {
        this.extraRequirements.add(ingredient);
        return this;
    }

    public ToolBuildingRecipeBuilder noParts() {
        this.partsOverride = new ArrayList<IToolPart>();
        return this;
    }

    public ToolBuildingRecipeBuilder partOverride(IToolPart part) {
        if (this.partsOverride == null) {
            this.partsOverride = new ArrayList<IToolPart>();
        }
        this.partsOverride.add(part);
        return this;
    }

    public ToolBuildingRecipeBuilder addExtraMaterial(MaterialVariantId material) {
        this.extraMaterials.add(material);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_5456_()));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "parts");
        if (this.tippedModifier != null) {
            if (this.extraMaterials.isEmpty()) {
                throw new IllegalArgumentException("Must have at least 1 material for modifier transform");
            }
            if (this.extraRequirements.size() != 1) {
                throw new IllegalArgumentException("Must have exactly one ingredient for modifier transform");
            }
            consumerIn.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new TippedToolTransformRecipe(id, this.group, this.output, this.layoutSlot, this.extraRequirements.get(0), this.extraMaterials, this.tippedModifier), TippedToolTransformRecipe.LOADER, advancementId));
        } else {
            consumerIn.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ToolBuildingRecipe(id, this.group, this.output, this.outputSize, this.layoutSlot, this.extraRequirements, this.partsOverride, this.extraMaterials), ToolBuildingRecipe.LOADER, advancementId));
        }
    }

    private ToolBuildingRecipeBuilder(IModifiable output) {
        this.output = output;
    }

    public static ToolBuildingRecipeBuilder toolBuildingRecipe(IModifiable output) {
        return new ToolBuildingRecipeBuilder(output);
    }

    public ToolBuildingRecipeBuilder outputSize(int outputSize) {
        this.outputSize = outputSize;
        return this;
    }

    public ToolBuildingRecipeBuilder layoutSlot(@Nullable ResourceLocation layoutSlot) {
        this.layoutSlot = layoutSlot;
        return this;
    }

    public ToolBuildingRecipeBuilder tippedModifier(@Nullable ModifierId tippedModifier) {
        this.tippedModifier = tippedModifier;
        return this;
    }
}

