/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.hook.special;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.modules.capacity.CapacityBarValidator;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface CapacityBarHook {
    public int getAmount(IToolStackView var1);

    public int getCapacity(IToolStackView var1, ModifierEntry var2);

    public void setAmount(IToolStackView var1, ModifierEntry var2, int var3);

    default public void addAmount(IToolStackView tool, ModifierEntry modifier, int amount) {
        this.setAmount(tool, modifier, this.getAmount(tool) + amount);
    }

    default public void removeAmount(IToolStackView tool, ModifierEntry modifier, int amount) {
        this.setAmount(tool, modifier, this.getAmount(tool) - amount);
    }

    public static abstract class PersistentDataCapacityBar
    implements CapacityBarHook,
    HookProvider {
        private static final List<ModuleHook<?>> HOOKS = HookProvider.defaultHooks(ModifierHooks.CAPACITY_BAR);
        protected final ResourceLocation key;

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return HOOKS;
        }

        @Override
        public void addModules(ModuleHookMap.Builder builder) {
            builder.addModule(new CapacityBarValidator(this));
        }

        @Override
        public int getAmount(IToolStackView tool) {
            return tool.getPersistentData().getInt(this.key);
        }

        @Override
        public void setAmount(IToolStackView tool, ModifierEntry entry, int amount) {
            if (amount <= 0) {
                tool.getPersistentData().remove(this.key);
            } else {
                tool.getPersistentData().putInt(this.key, Math.min(amount, this.getCapacity(tool, entry)));
            }
        }

        public PersistentDataCapacityBar(ResourceLocation key) {
            this.key = key;
        }
    }
}

