package slimeknights.tconstruct.tools.data.sprite;

import net.minecraft.world.item.ArmorItem;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

/**
 * This class handles all tool part sprites generated by Tinkers' Construct. You can freely use this in your addon to generate TiC part textures for a new material
 * Do not use both this and {@link TinkerMaterialSpriteProvider} in a single generator for an addon, if you need to use both make two instances of {@link slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator}
 */
public class TinkerPartSpriteProvider extends AbstractPartSpriteProvider {
  public static final MaterialStatsId WOOD = new MaterialStatsId(TConstruct.MOD_ID, "wood");
  public static final MaterialStatsId SLIMESUIT = new MaterialStatsId(TConstruct.MOD_ID, "slimesuit");
  public static final MaterialStatsId ARMOR_PLATING = new MaterialStatsId(TConstruct.MOD_ID, "armor_plating");
  public static final MaterialStatsId ARMOR_MAILLE = new MaterialStatsId(TConstruct.MOD_ID, "armor_maille");
  public static final MaterialStatsId ARMOR_CUIRASS = new MaterialStatsId(TConstruct.MOD_ID, "armor_cuirass");

  public TinkerPartSpriteProvider() {
    super(TConstruct.MOD_ID);
  }

  @Override
  public String getName() {
    return "Tinkers' Construct Parts";
  }

  @Override
  protected void addAllSpites() {
    // heads
    addHead("large_plate");
    addHead("small_blade");
    // handles
    addHandle("tool_handle");
    addHandle("tough_handle");
    // bow
    addBowstring("bowstring");
    // misc
    addBinding("tool_binding");
    addBinding("tough_binding");
    addPart("repair_kit", StatlessMaterialStats.REPAIR_KIT.getIdentifier());

    // travelers textures
    addTexture("tinker_armor/travelers/metal_armor", ARMOR_PLATING).disallowAnimated();
    addTexture("tinker_armor/travelers/metal_leggings", ARMOR_PLATING).disallowAnimated();
    addTexture("tinker_armor/travelers/cuirass_armor", ARMOR_CUIRASS).disallowAnimated();
    addTexture("tinker_armor/travelers/cuirass_leggings", ARMOR_CUIRASS).disallowAnimated();
    addTexture("tinker_armor/travelers/cuirass_wings", ARMOR_CUIRASS).disallowAnimated();
    // items - no loop as each has a unique name
    buildTool("armor/travelers/goggles").disallowAnimated()
      .addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier())
      .addBreakablePart("metal", PlatingMaterialStats.HELMET.getId());
    buildTool("armor/travelers/vest").disallowAnimated()
      .addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier())
      .addBreakablePart("metal", PlatingMaterialStats.CHESTPLATE.getId());
    buildTool("armor/travelers/pants").disallowAnimated()
      .addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier())
      .addBreakablePart("metal", PlatingMaterialStats.LEGGINGS.getId());
    buildTool("armor/travelers/boots").disallowAnimated()
      .addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier())
      .addBreakablePart("metal", PlatingMaterialStats.BOOTS.getId());
    buildTool("armor/travelers/shield")
      .addBreakablePart("cuirass", StatlessMaterialStats.CUIRASS.getIdentifier())
      .addBreakablePart("wood", StatlessMaterialStats.SHIELD_CORE.getIdentifier());

    // plate textures
    addPart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
    for (ArmorItem.Type slot : ArmorItem.Type.values()) {
      buildTool("armor/plate/" + slot.getName()).disallowAnimated() // the armor model won't be animated, so don't animate the item
        .addBreakablePart("plating", PlatingMaterialStats.TYPES.get(slot.ordinal()).getId())
        .addBreakablePart("maille", StatlessMaterialStats.MAILLE.getIdentifier());
    }
    addTexture("tinker_armor/plate/plating_armor", ARMOR_PLATING).disallowAnimated();
    addTexture("tinker_armor/plate/plating_leggings", ARMOR_PLATING).disallowAnimated();
    addTexture("tinker_armor/plate/maille_armor", ARMOR_MAILLE).disallowAnimated();
    addTexture("tinker_armor/plate/maille_leggings", ARMOR_MAILLE).disallowAnimated();
    addTexture("tinker_armor/plate/maille_wings", ARMOR_MAILLE).disallowAnimated();
    buildTool("armor/plate/shield")
      .addBreakablePart("plating", PlatingMaterialStats.SHIELD.getId())
      .addBreakablePart("core", StatlessMaterialStats.SHIELD_CORE.getIdentifier())
      // withLarge wants to use a subfolder, easier to just add another part than special casing
      .addBreakablePart("plating_large", PlatingMaterialStats.SHIELD.getId())
      .addBreakablePart("core_large", StatlessMaterialStats.SHIELD_CORE.getIdentifier());

    // staff
    addSprite("staff/modifiers/tconstruct_embellishment", WOOD);
    addSprite("staff/large_modifiers/tconstruct_embellishment", WOOD);

    // slimesuit textures - the armor model won't be animated, so don't animate the item
    addSprite("armor/slime/skull_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/skull_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/wings_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/wings_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/shell_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/shell_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/boot_modifiers/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addSprite("armor/slime/boot_modifiers/broken/tconstruct_embellishment", SLIMESUIT).disallowAnimated();
    addTexture("tinker_armor/slime/armor", SLIMESUIT).disallowAnimated();
    addTexture("tinker_armor/slime/leggings", SLIMESUIT).disallowAnimated();
    addTexture("tinker_armor/slime/wings", SLIMESUIT).disallowAnimated();

    // tools
    // pickaxe - regular variant uses handle on frypans as a grip so generate those too
    buildTool("pickaxe").addBreakableHead("head").addHandle("handle").addBinding("binding");
    buildTool("sledge_hammer").withLarge().addBreakableHead("head").addBreakableHead("back").addBreakableHead("front").addHandle("handle");
    buildTool("vein_hammer").withLarge().addBreakableHead("head").addBinding("grip").addBreakableHead("front").addHandle("handle");
    // shovel
    buildTool("mattock").addBreakableHead("axe").addBreakableHead("pick"); // handle provided by pickaxe
    buildTool("pickadze").addBreakableHead("pick").addHead("adze"); // handle provided by pickaxe
    buildTool("excavator").withLarge().addBreakableHead("head").addBinding("binding").addHandle("handle").addHandle("grip");
    // axe
    buildTool("hand_axe").addBreakableHead("head").addBinding("binding"); // handle provided by pickaxe
    buildTool("broad_axe").withLarge().addBreakableHead("blade").addBreakableHead("back").addHandle("handle").addBinding("binding");
    // scythe
    buildTool("kama").addBreakableHead("head").addBinding("binding"); // handle provided by pickaxe
    buildTool("scythe").withLarge().addBreakableHead("head").addHandle("handle").addHandle("accessory").addBinding("binding");
    // sword
    buildTool("dagger").addBreakableHead("blade").addHandle("crossguard");
    buildTool("sword").addBreakableHead("blade").addHandle("guard").addHandle("handle");
    buildTool("cleaver").withLarge().addBreakableHead("head").addBreakableHead("shield").addHandle("handle").addHandle("guard");
    // bow
    buildTool("crossbow")
      .addLimb("limb").addGrip("body")
      .addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
    buildTool("longbow").withLarge()
      .addLimb("limb_bottom").addLimb("limb_bottom_1").addLimb("limb_bottom_2").addLimb("limb_bottom_3")
      .addLimb("limb_top").addLimb("limb_top_1").addLimb("limb_top_2").addLimb("limb_top_3")
      .addGrip("grip")
      .addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
    buildTool("fishing_rod")
      .addLimb("rod")
      .addBreakableBowstring("string").addBowstring("string_cast")
      .addBreakablePart("hook", StatlessMaterialStats.ARROW_HEAD.getIdentifier());
    buildTool("javelin").withLarge().addBreakableHead("head").addLimb("guard").addHandle("handle").addGrip("grip");
    buildTool("ammo")
      // arrow
      .addArrowHead("arrow_head").addPart("arrow_shaft", StatlessMaterialStats.ARROW_SHAFT)
      // shuriken
      .addArrowHead("shuriken_top").addArrowHead("shuriken_bottom")
      // throwing axe - reuses arrow shaft
      .addArrowHead("axe_head");

    // ancient tools
    buildTool("melting_pan").skipVariants().addBreakablePart("head", PlatingMaterialStats.SHIELD.getId()).addLimb("handle");
    buildTool("war_pick").skipVariants().addHead("limb").addLimb("body")
                         .addBreakableBowstring("bowstring").addBowstring("bowstring_1").addBowstring("bowstring_2").addBowstring("bowstring_3");
    buildTool("battlesign").skipVariants().addBreakableHead("head").addPart("handle", PlatingMaterialStats.SHIELD.getId());
    buildTool("swasher").skipVariants().addBreakableHead("blade").addHandle("handle")
                        .addGrip("barrel").addGrip("barrel_1").addGrip("barrel_2");
    buildTool("minotaur_axe").skipVariants().addBreakableHead("front").addHead("back");
  }
}
