/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged.ammo;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.util.TranslationHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;

public enum SmashingModule implements ModifierModule,
ToolFluidCapability.FluidModifierHook,
ProjectileLaunchModifierHook.NoShooter,
ProjectileHitModifierHook,
VolatileDataModifierHook,
ValidateModifierHook,
ModifierRemovalHook,
DisplayNameModifierHook,
TooltipModifierHook
{
    INSTANCE;

    private static final ResourceLocation KEY_FLUID;
    private static final ResourceLocation KEY_FLUID_TAG;
    private static final ResourceLocation KEY_AMOUNT;
    private static final ResourceLocation KEY_VALIDATE;
    private static final ResourceLocation KEY_USED;
    private static final String FORMAT;
    private static final Component EMPTY_TO_SWAP;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<SmashingModule> LOADER;
    public static ToolTankHelper TANK_HELPER;

    public RecordLoadable<SmashingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private static int getAmount(Fluid fluid) {
        FluidEffects effects = FluidEffectManager.INSTANCE.find(fluid);
        return effects.hasEffects() ? effects.ingredient().getAmount(fluid) : 0;
    }

    private static int getAmount(ModifierEntry modifier, Fluid fluid) {
        return SmashingModule.getAmount(fluid) * modifier.getLevel();
    }

    private static Fluid getFluid(IModDataView data) {
        ResourceLocation id;
        if (data.contains(KEY_FLUID, 8) && (id = ResourceLocation.m_135820_((String)data.getString(KEY_FLUID))) != null) {
            return (Fluid)BuiltInRegistries.f_257020_.m_7745_(id);
        }
        return Fluids.f_76191_;
    }

    @Nullable
    private static CompoundTag getFluidTag(IModDataView data) {
        if (data.contains(KEY_FLUID_TAG, 10)) {
            return data.getCompound(KEY_FLUID_TAG);
        }
        return null;
    }

    private static void clearFluid(ModDataNBT data) {
        data.remove(KEY_FLUID);
        data.remove(KEY_VALIDATE);
        data.remove(KEY_AMOUNT);
        data.remove(KEY_FLUID_TAG);
    }

    private static int getValidationAmount(IToolStackView tool, ModifierEntry modifier) {
        int level = modifier.getLevel();
        for (ModifierEntry entry : tool.getModifiers()) {
            level = entry.getHook(ModifierHooks.CRAFT_COUNT).modifyCraftCount(tool, modifier, level);
        }
        return level;
    }

    @Override
    public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(KEY_FLUID, 8)) {
            return 0;
        }
        int amount = SmashingModule.getAmount(modifier, resource.getFluid());
        if (amount == 0 || resource.getAmount() < amount) {
            return 0;
        }
        if (action.execute()) {
            data.putString(KEY_FLUID, Loadables.FLUID.getString((Object)resource.getFluid()));
            data.putInt(KEY_VALIDATE, SmashingModule.getValidationAmount(tool, modifier));
            CompoundTag tag = resource.getTag();
            if (tag != null) {
                data.put(KEY_FLUID_TAG, (Tag)tag.m_6426_());
            }
        }
        return amount;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
        ModDataNBT data;
        Fluid fluid;
        if (maxDrain > 0 && (fluid = SmashingModule.getFluid(data = tool.getPersistentData())) != Fluids.f_76191_) {
            int amount = SmashingModule.getAmount(modifier, fluid);
            if (amount <= 0) {
                SmashingModule.clearFluid(data);
            } else if (amount <= maxDrain) {
                FluidStack result = new FluidStack(fluid, amount, SmashingModule.getFluidTag(data));
                if (action.execute()) {
                    SmashingModule.clearFluid(data);
                }
                return result;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        ModDataNBT data;
        Fluid fluid;
        if (!resource.isEmpty() && (fluid = SmashingModule.getFluid(data = tool.getPersistentData())) != Fluids.f_76191_ && resource.getFluid() == fluid) {
            CompoundTag storedTag;
            int amount = SmashingModule.getAmount(modifier, fluid);
            if (amount <= 0) {
                SmashingModule.clearFluid(data);
            } else if (amount <= resource.getAmount() && Objects.equals(storedTag = SmashingModule.getFluidTag(data), resource.getTag())) {
                FluidStack result = new FluidStack(fluid, amount, storedTag);
                if (action.execute()) {
                    SmashingModule.clearFluid(data);
                }
                return result;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
        ModDataNBT data = tool.getPersistentData();
        Fluid fluid = SmashingModule.getFluid(data);
        if (fluid != Fluids.f_76191_) {
            int amount = SmashingModule.getAmount(modifier, fluid);
            if (amount > 0) {
                return new FluidStack(fluid, amount, SmashingModule.getFluidTag(data));
            }
            SmashingModule.clearFluid(data);
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
        Fluid fluid = SmashingModule.getFluid(tool.getPersistentData());
        if (fluid != Fluids.f_76191_) {
            return SmashingModule.getAmount(modifier, fluid);
        }
        return 250;
    }

    @Override
    public boolean isFluidValid(IToolStackView tool, ModifierEntry modifier, int tank, FluidStack fluid) {
        return SmashingModule.getAmount(fluid.getFluid()) > 0;
    }

    @Override
    public void addVolatileData(IToolContext context, ModifierEntry modifier, ToolDataNBT volatileData) {
        ToolFluidCapability.addTanks(modifier, volatileData, this);
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(KEY_FLUID, 8)) {
            int level = SmashingModule.getValidationAmount(tool, modifier);
            if (data.getInt(KEY_VALIDATE) < level) {
                return EMPTY_TO_SWAP;
            }
            data.putInt(KEY_VALIDATE, level);
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        SmashingModule.clearFluid(tool.getPersistentData());
        return null;
    }

    @Override
    public void onProjectileShoot(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity shooter, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        block6: {
            int amount;
            ModDataNBT toolData;
            Fluid fluid;
            block5: {
                if (arrow == null || arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) break block5;
                if (!(shooter instanceof Player)) break block6;
                Player player = (Player)shooter;
                if (!player.m_150110_().f_35937_) break block6;
            }
            if ((fluid = SmashingModule.getFluid(toolData = tool.getPersistentData())) != Fluids.f_76191_ && (amount = SmashingModule.getAmount(modifier, fluid)) > 0) {
                persistentData.putString(KEY_FLUID, toolData.getString(KEY_FLUID));
                persistentData.putInt(KEY_AMOUNT, amount);
                if (toolData.contains(KEY_FLUID_TAG, 10)) {
                    persistentData.put(KEY_FLUID_TAG, (Tag)toolData.getCompound(KEY_FLUID_TAG));
                }
            }
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, boolean notBlocked) {
        Fluid fluid = SmashingModule.getFluid(persistentData);
        if (fluid != Fluids.f_76191_) {
            int amount = persistentData.getInt(KEY_AMOUNT);
            if (amount > 0) {
                int drained;
                FluidEffects effects = FluidEffectManager.INSTANCE.find(fluid);
                if (effects.hasEntityEffects() && (drained = effects.applyToEntity(new FluidStack(fluid, amount, SmashingModule.getFluidTag(persistentData)), modifier.getEffectiveLevel(), FluidEffectContext.builder(projectile.m_9236_()).user(attacker).projectile(projectile).location(hit.m_82450_()).target(hit.m_82443_(), target), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    int remaining = amount - drained;
                    if (remaining > 0) {
                        persistentData.putInt(KEY_AMOUNT, remaining);
                    } else {
                        SmashingModule.clearFluid(persistentData);
                    }
                    projectile.m_216990_(SoundEvents.f_12436_);
                    if (projectile instanceof AbstractArrow) {
                        persistentData.putBoolean(KEY_USED, true);
                    } else {
                        projectile.m_146870_();
                    }
                }
            } else {
                SmashingModule.clearFluid(persistentData);
            }
        }
        return projectile.m_213877_();
    }

    @Override
    public void onProjectileHitBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity attacker) {
        Fluid fluid = SmashingModule.getFluid(persistentData);
        boolean used = false;
        if (fluid != Fluids.f_76191_) {
            int amount = persistentData.getInt(KEY_AMOUNT);
            if (amount > 0) {
                int drained;
                FluidEffects effects = FluidEffectManager.INSTANCE.find(fluid);
                if (effects.hasBlockEffects() && (drained = effects.applyToBlock(new FluidStack(fluid, amount, SmashingModule.getFluidTag(persistentData)), modifier.getEffectiveLevel(), FluidEffectContext.builder(projectile.m_9236_()).user(attacker).projectile(projectile).location(hit.m_82450_()).block(hit), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    int remaining = amount - drained;
                    used = true;
                    if (remaining > 0) {
                        persistentData.putInt(KEY_AMOUNT, remaining);
                    } else {
                        SmashingModule.clearFluid(persistentData);
                    }
                }
            } else {
                SmashingModule.clearFluid(persistentData);
            }
        }
        if (used || persistentData.getBoolean(KEY_USED)) {
            projectile.m_216990_(SoundEvents.f_12436_);
            projectile.m_146870_();
        }
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        ModDataNBT data = tool.getPersistentData();
        Fluid fluid = SmashingModule.getFluid(data);
        if (fluid != Fluids.f_76191_) {
            return Component.m_237110_((String)FORMAT, (Object[])new Object[]{name, new FluidStack(fluid, 250, SmashingModule.getFluidTag(data)).getDisplayName()}).m_130948_(name.m_7383_());
        }
        return name;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        int amount;
        ModDataNBT data = tool.getPersistentData();
        Fluid fluid = SmashingModule.getFluid(data);
        if (fluid != Fluids.f_76191_ && (amount = SmashingModule.getAmount(modifier, fluid)) > 0) {
            tooltip.add((Component)modifier.getModifier().applyStyle(new FluidStack(fluid, amount, SmashingModule.getFluidTag(data)).getDisplayName().m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237110_((String)ToolTankHelper.MB_FORMAT, (Object[])new Object[]{TranslationHelper.COMMA_FORMAT.format(amount)}))));
        }
    }

    static {
        KEY_FLUID = TConstruct.getResource("smashing_fluid");
        KEY_FLUID_TAG = TConstruct.getResource("smashing_fluid_tag");
        KEY_AMOUNT = TConstruct.getResource("smashing_amount");
        KEY_VALIDATE = TConstruct.getResource("smashing_validate");
        KEY_USED = TConstruct.getResource("smashing_used");
        FORMAT = TConstruct.makeTranslationKey("modifier", "smashing.format");
        EMPTY_TO_SWAP = TConstruct.makeTranslation("modifier", "smashing.empty_to_swap");
        DEFAULT_HOOKS = HookProvider.defaultHooks(ToolFluidCapability.HOOK, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.PROJECTILE_HIT, ModifierHooks.VOLATILE_DATA, ModifierHooks.VALIDATE, ModifierHooks.REMOVE, ModifierHooks.DISPLAY_NAME, ModifierHooks.TOOLTIP);
        LOADER = new SingletonLoader((Object)INSTANCE);
        TANK_HELPER = new ToolTankHelper((INumericToolStat)ToolTankHelper.CAPACITY_STAT, KEY_FLUID){

            @Override
            public FluidStack getFluid(IToolStackView tool) {
                int amount;
                ModDataNBT data = tool.getPersistentData();
                Fluid fluid = SmashingModule.getFluid(data);
                if (fluid != Fluids.f_76191_ && (amount = SmashingModule.getAmount(fluid)) > 0) {
                    return new FluidStack(fluid, amount, SmashingModule.getFluidTag(data));
                }
                return FluidStack.EMPTY;
            }

            @Override
            @Deprecated
            public FluidStack setFluid(IToolStackView tool, FluidStack fluid) {
                return FluidStack.EMPTY;
            }

            @Override
            public int getCapacity(IToolStackView tool) {
                ModDataNBT data = tool.getPersistentData();
                Fluid fluid = SmashingModule.getFluid(data);
                if (fluid != Fluids.f_76191_) {
                    return SmashingModule.getAmount(fluid);
                }
                return 250;
            }
        };
    }
}

