/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.events.teleport.ModifierTeleportEvent;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.TeleportHelper;
import slimeknights.tconstruct.tools.modules.armor.CounterModule;

public record EnderclearanceModule(LevelingValue chance, LevelingInt diameter, LevelingInt teleportChances) implements ModifierModule,
ProjectileHitModifierHook,
MeleeHitModifierHook,
OnAttackedModifierHook
{
    private static final LevelingInt DEFAULT = LevelingInt.flat(16);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.ON_ATTACKED);
    @Deprecated(forRemoval=true)
    public static final EnderclearanceModule INSTANCE = new EnderclearanceModule(LevelingValue.eachLevel(0.25f));
    public static final RecordLoadable<EnderclearanceModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("chance", EnderclearanceModule::chance), (RecordField)LevelingInt.LOADABLE.defaultField("diameter", (Object)DEFAULT, true, EnderclearanceModule::diameter), (RecordField)LevelingInt.LOADABLE.defaultField("teleport_chances", (Object)DEFAULT, true, EnderclearanceModule::teleportChances), EnderclearanceModule::new);

    @Deprecated(forRemoval=true)
    public EnderclearanceModule(LevelingValue chance) {
        this(chance, DEFAULT, DEFAULT);
    }

    public RecordLoadable<? extends GenericLoaderRegistry.IHaveLoader> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private void teleport(ModifierEntry modifier, @Nullable LivingEntity target) {
        if (target != null) {
            float level = modifier.getEffectiveLevel();
            TeleportHelper.randomNearbyTeleport(target, (e, x, y, z) -> new ModifierTeleportEvent((Entity)e, x, y, z, modifier), this.diameter.compute(level), this.teleportChances.compute(level));
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.teleport(modifier, context.getLivingTarget());
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity entity;
        if (isDirectDamage && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            float level = CounterModule.getLevel(tool, modifier, slotType, context.getEntity());
            if (attacker.m_217043_().m_188501_() < this.chance.compute(level)) {
                this.teleport(modifier, attacker);
            }
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        this.teleport(modifier, target);
        return false;
    }
}

